/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationFunction;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterServiceNameProvider;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class ModClusterLoadBalancingGroupDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"load-balancing-group");
    static final ResourceDescriptionResolver RESOLVER = UndertowExtension.getResolver("filter", ModClusterDefinition.PATH_ELEMENT.getKey(), ModClusterBalancerDefinition.PATH_ELEMENT.getKey(), PATH_ELEMENT.getKey());
    private final FunctionExecutorRegistry<ModCluster> registry;
    static final Function<OperationContext, Function<ModCluster, Map.Entry<ModClusterStatus.LoadBalancer, String>>> LOAD_BALANCING_GROUP_FUNCTION_FACTORY = new Function<OperationContext, Function<ModCluster, Map.Entry<ModClusterStatus.LoadBalancer, String>>>(){

        @Override
        public Function<ModCluster, Map.Entry<ModClusterStatus.LoadBalancer, String>> apply(OperationContext context) {
            PathAddress groupAddress = context.getCurrentAddress();
            String groupName = groupAddress.getLastElement().getValue();
            PathAddress balancerAddress = groupAddress.getParent();
            String balancerName = balancerAddress.getLastElement().getValue();
            return new LoadBalancingGroupFunction(balancerName, groupName);
        }
    };

    ModClusterLoadBalancingGroupDefinition(FunctionExecutorRegistry<ModCluster> registry) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, RESOLVER).setRuntime());
        this.registry = registry;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        new OperationHandler((OperationExecutor)new LoadBalancingGroupOperationExecutor(this.registry), LoadBalancingGroupOperation.class).register(resourceRegistration);
    }

    static class LoadBalancingGroupOperationExecutor
    implements OperationExecutor<Map.Entry<ModClusterStatus.LoadBalancer, String>> {
        private final FunctionExecutorRegistry<ModCluster> registry;

        LoadBalancingGroupOperationExecutor(FunctionExecutorRegistry<ModCluster> registry) {
            this.registry = registry;
        }

        public ModelNode execute(OperationContext context, ModelNode op, Operation<Map.Entry<ModClusterStatus.LoadBalancer, String>> operation) throws OperationFailedException {
            PathAddress serviceAddress = context.getCurrentAddress().getParent().getParent();
            FunctionExecutor executor = this.registry.getExecutor((Object)ServiceDependency.on((ServiceName)new ModClusterServiceNameProvider(serviceAddress).getServiceName()));
            Function<ModCluster, Map.Entry<ModClusterStatus.LoadBalancer, String>> mapper = LOAD_BALANCING_GROUP_FUNCTION_FACTORY.apply(context);
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new OperationFunction((ExpressionResolver)context, op, mapper, operation)) : null;
        }
    }

    static enum LoadBalancingGroupOperation implements Operation<Map.Entry<ModClusterStatus.LoadBalancer, String>>
    {
        ENABLE_NODES("enable-nodes", ModClusterStatus.Context::enable),
        DISABLE_NODES("disable-nodes", ModClusterStatus.Context::disable),
        STOP_NODES("stop-nodes", ModClusterStatus.Context::stop);

        private OperationDefinition definition;
        private final Consumer<ModClusterStatus.Context> operation;

        private LoadBalancingGroupOperation(String name, Consumer<ModClusterStatus.Context> operation) {
            this.definition = SimpleOperationDefinitionBuilder.of((String)name, (ResourceDescriptionResolver)RESOLVER).setRuntimeOnly().build();
            this.operation = operation;
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, Map.Entry<ModClusterStatus.LoadBalancer, String> entry) {
            ModClusterStatus.LoadBalancer balancer = entry.getKey();
            String groupName = entry.getValue();
            for (ModClusterStatus.Node node : balancer.getNodes()) {
                if (!groupName.equals(node.getDomain())) continue;
                for (ModClusterStatus.Context context : node.getContexts()) {
                    this.operation.accept(context);
                }
            }
            return null;
        }

        public OperationDefinition getDefinition() {
            return this.definition;
        }
    }

    static class LoadBalancingGroupFunction
    implements Function<ModCluster, Map.Entry<ModClusterStatus.LoadBalancer, String>> {
        private final String balancerName;
        private final String groupName;

        LoadBalancingGroupFunction(String balancerName, String groupName) {
            this.balancerName = balancerName;
            this.groupName = groupName;
        }

        @Override
        public Map.Entry<ModClusterStatus.LoadBalancer, String> apply(ModCluster service) {
            ModClusterStatus.LoadBalancer balancer = service.getController().getStatus().getLoadBalancer(this.balancerName);
            return balancer != null ? Map.entry(balancer, this.groupName) : null;
        }
    }
}

