/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.tuples;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.mutiny.tuples.Tuple3;
import io.smallrye.mutiny.tuples.Tuple4;
import io.smallrye.mutiny.tuples.Tuple5;
import io.smallrye.mutiny.tuples.Tuple6;
import io.smallrye.mutiny.tuples.Tuple7;
import io.smallrye.mutiny.tuples.Tuple8;
import io.smallrye.mutiny.tuples.Tuple9;
import java.util.List;

public abstract class Tuples {
    private Tuples() {
    }

    public static <L, R> Tuple2<L, R> tuple2(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 2) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 2 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple2.of(list.get(0), list.get(1));
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> tuple3(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 3) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 3 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple3.of(list.get(0), list.get(1), list.get(2));
    }

    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> tuple4(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 4) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 4 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple4.of(list.get(0), list.get(1), list.get(2), list.get(3));
    }

    public static <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> tuple5(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 5) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 5 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple5.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4));
    }

    public static <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> tuple6(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 6) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 6 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple6.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> tuple7(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 7) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 7 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple7.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> tuple8(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 8) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 8 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple8.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), list.get(7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> tuple9(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 9) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 9 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple9.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), list.get(7), list.get(8));
    }

    public static void ensureArity(List<?> parameters, int expectedSize) {
        if (parameters.size() != expectedSize) {
            throw new IllegalArgumentException("Cannot call combinator from list. Expected size: " + expectedSize + ", Actual size: " + parameters.size());
        }
    }
}

