/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.Objects;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.impl.Util;

public class SyncStrongCounterAdapter
implements SyncStrongCounter {
    private final StrongCounter counter;

    public SyncStrongCounterAdapter(StrongCounter counter) {
        this.counter = Objects.requireNonNull(counter);
    }

    public long addAndGet(long delta) {
        return (Long)Util.awaitCounterOperation(this.counter.addAndGet(delta));
    }

    public void reset() {
        Util.awaitCounterOperation(this.counter.reset());
    }

    public long getValue() {
        return (Long)Util.awaitCounterOperation(this.counter.getValue());
    }

    public long compareAndSwap(long expect, long update) {
        return (Long)Util.awaitCounterOperation(this.counter.compareAndSwap(expect, update));
    }

    public String getName() {
        return this.counter.getName();
    }

    public CounterConfiguration getConfiguration() {
        return this.counter.getConfiguration();
    }

    public void remove() {
        Util.awaitCounterOperation(this.counter.remove());
    }

    public long getAndSet(long value) {
        return (Long)Util.awaitCounterOperation(this.counter.getAndSet(value));
    }

    public String toString() {
        return "SyncStrongCounter{counter=" + String.valueOf(this.counter) + "}";
    }
}

