/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HotRodStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemSchema;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OffHeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XMLAttribute;
import org.jboss.as.clustering.infinispan.subsystem.XMLElement;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.iteration.CompositeIterable;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(InfinispanSubsystemSchema.CURRENT.getNamespace().getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined(CacheContainerResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property entry : model.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    Object cache;
                    String containerName = entry.getName();
                    ModelNode container = entry.getValue();
                    writer.writeStartElement(XMLElement.CACHE_CONTAINER.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), containerName);
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, container, CacheContainerResourceDefinition.Attribute.class);
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, container, CacheContainerResourceDefinition.ListAttribute.class);
                    if (container.hasDefined(JGroupsTransportResourceDefinition.PATH.getKeyValuePair())) {
                        writer.writeStartElement(XMLElement.TRANSPORT.getLocalName());
                        ModelNode transport = container.get(JGroupsTransportResourceDefinition.PATH.getKeyValuePair());
                        InfinispanSubsystemXMLWriter.writeAttributes(writer, transport, EnumSet.allOf(JGroupsTransportResourceDefinition.Attribute.class));
                        writer.writeEndElement();
                    }
                    if (container.hasDefined(ThreadPoolResourceDefinition.WILDCARD_PATH.getKey())) {
                        InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.BLOCKING_THREAD_POOL, ThreadPoolResourceDefinition.BLOCKING, writer, container);
                        InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.LISTENER_THREAD_POOL, ThreadPoolResourceDefinition.LISTENER, writer, container);
                        InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.NON_BLOCKING_THREAD_POOL, ThreadPoolResourceDefinition.NON_BLOCKING, writer, container);
                        InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(XMLElement.EXPIRATION_THREAD_POOL, ScheduledThreadPoolResourceDefinition.EXPIRATION, writer, container);
                    }
                    if (container.hasDefined(LocalCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property property : container.get(LocalCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            cache = property.getValue();
                            writer.writeStartElement(XMLElement.LOCAL_CACHE.getLocalName());
                            InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, property.getName(), (ModelNode)cache);
                            InfinispanSubsystemXMLWriter.writeCacheElements(writer, (ModelNode)cache);
                            writer.writeEndElement();
                        }
                    }
                    if (container.hasDefined(InvalidationCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property property : container.get(InvalidationCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            cache = property.getValue();
                            writer.writeStartElement(XMLElement.INVALIDATION_CACHE.getLocalName());
                            InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), (ModelNode)cache);
                            InfinispanSubsystemXMLWriter.writeCacheElements(writer, (ModelNode)cache);
                            writer.writeEndElement();
                        }
                    }
                    if (container.hasDefined(ReplicatedCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property property : container.get(ReplicatedCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            cache = property.getValue();
                            writer.writeStartElement(XMLElement.REPLICATED_CACHE.getLocalName());
                            InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), (ModelNode)cache);
                            InfinispanSubsystemXMLWriter.writeCacheElements(writer, (ModelNode)cache);
                            writer.writeEndElement();
                        }
                    }
                    if (container.hasDefined(DistributedCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property property : container.get(DistributedCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            cache = property.getValue();
                            writer.writeStartElement(XMLElement.DISTRIBUTED_CACHE.getLocalName());
                            InfinispanSubsystemXMLWriter.writeSegmentedCacheAttributes(writer, property.getName(), (ModelNode)cache);
                            InfinispanSubsystemXMLWriter.writeAttributes(writer, (ModelNode)cache, EnumSet.allOf(DistributedCacheResourceDefinition.Attribute.class));
                            InfinispanSubsystemXMLWriter.writeCacheElements(writer, (ModelNode)cache);
                            writer.writeEndElement();
                        }
                    }
                    if (container.hasDefined(ScatteredCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property property : container.get(ScatteredCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            cache = property.getValue();
                            writer.writeStartElement(XMLElement.SCATTERED_CACHE.getLocalName());
                            InfinispanSubsystemXMLWriter.writeSegmentedCacheAttributes(writer, property.getName(), (ModelNode)cache);
                            InfinispanSubsystemXMLWriter.writeAttributes(writer, (ModelNode)cache, EnumSet.allOf(ScatteredCacheResourceDefinition.Attribute.class));
                            InfinispanSubsystemXMLWriter.writeCacheElements(writer, (ModelNode)cache);
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
            }
            if (model.hasDefined(RemoteCacheContainerResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property entry : model.get(RemoteCacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    String remoteContainerName = entry.getName();
                    ModelNode remoteContainer = entry.getValue();
                    writer.writeStartElement(XMLElement.REMOTE_CACHE_CONTAINER.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), remoteContainerName);
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, remoteContainer, EnumSet.complementOf(EnumSet.of(RemoteCacheContainerResourceDefinition.Attribute.PROPERTIES)));
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, remoteContainer, RemoteCacheContainerResourceDefinition.ListAttribute.class);
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, remoteContainer, EnumSet.allOf(RemoteCacheContainerResourceDefinition.DeprecatedAttribute.class));
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.ASYNC_THREAD_POOL, ClientThreadPoolResourceDefinition.ASYNC, writer, remoteContainer);
                    ModelNode connectionPool = remoteContainer.get(ConnectionPoolResourceDefinition.PATH.getKeyValuePair());
                    EnumSet<ConnectionPoolResourceDefinition.Attribute> attributes = EnumSet.allOf(ConnectionPoolResourceDefinition.Attribute.class);
                    if (InfinispanSubsystemXMLWriter.hasDefined(connectionPool, attributes)) {
                        writer.writeStartElement(XMLElement.CONNECTION_POOL.getLocalName());
                        InfinispanSubsystemXMLWriter.writeAttributes(writer, connectionPool, attributes);
                        writer.writeEndElement();
                    }
                    InfinispanSubsystemXMLWriter.writeElement(writer, remoteContainer, StoreResourceDefinition.Attribute.PROPERTIES);
                    writer.writeStartElement(XMLElement.REMOTE_CLUSTERS.getLocalName());
                    for (Property clusterEntry : remoteContainer.get(RemoteClusterResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                        writer.writeStartElement(XMLElement.REMOTE_CLUSTER.getLocalName());
                        String remoteClusterName = clusterEntry.getName();
                        ModelNode remoteCluster = clusterEntry.getValue();
                        writer.writeAttribute(XMLAttribute.NAME.getLocalName(), remoteClusterName);
                        InfinispanSubsystemXMLWriter.writeAttributes(writer, remoteCluster, RemoteClusterResourceDefinition.Attribute.class);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    ModelNode securityModel = remoteContainer.get(SecurityResourceDefinition.PATH.getKeyValuePair());
                    EnumSet<SecurityResourceDefinition.Attribute> securityAttributes = EnumSet.allOf(SecurityResourceDefinition.Attribute.class);
                    if (InfinispanSubsystemXMLWriter.hasDefined(securityModel, securityAttributes)) {
                        writer.writeStartElement(XMLElement.SECURITY.getLocalName());
                        InfinispanSubsystemXMLWriter.writeAttributes(writer, securityModel, securityAttributes);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
        writer.writeEndElement();
    }

    private static void writeCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        writer.writeAttribute(XMLAttribute.NAME.getLocalName(), name);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, CacheResourceDefinition.Attribute.class);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, CacheResourceDefinition.ListAttribute.class);
    }

    private static void writeClusteredCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, name, cache);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, ClusteredCacheResourceDefinition.Attribute.class);
    }

    private static void writeSegmentedCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, name, cache);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, SegmentedCacheResourceDefinition.Attribute.class);
    }

    private static void writeCacheElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode backups;
        ModelNode stateTransfer;
        EnumSet<Enum> attributes;
        ModelNode partitionHandling;
        ModelNode store;
        ModelNode expiration;
        ModelNode memory;
        ModelNode transaction;
        CompositeIterable attributes2;
        ModelNode locking;
        if (cache.hasDefined(LockingResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(locking = cache.get(LockingResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(LockingResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.LOCKING.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, locking, attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(TransactionResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(transaction = cache.get(TransactionResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(TransactionResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.TRANSACTION.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, transaction, attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(HeapMemoryResourceDefinition.PATH.getKeyValuePair())) {
            memory = cache.get(HeapMemoryResourceDefinition.PATH.getKeyValuePair());
            if (InfinispanSubsystemXMLWriter.hasDefined(memory, (Iterable<? extends Attribute>)(attributes2 = new CompositeIterable(new Iterable[]{EnumSet.allOf(MemoryResourceDefinition.Attribute.class), EnumSet.allOf(HeapMemoryResourceDefinition.Attribute.class)})))) {
                writer.writeStartElement(XMLElement.HEAP_MEMORY.getLocalName());
                InfinispanSubsystemXMLWriter.writeAttributes(writer, memory, (Iterable<? extends Attribute>)attributes2);
                writer.writeEndElement();
            }
        } else if (cache.hasDefined(OffHeapMemoryResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(memory = cache.get(OffHeapMemoryResourceDefinition.PATH.getKeyValuePair()), (Iterable<? extends Attribute>)(attributes2 = new CompositeIterable(new Iterable[]{EnumSet.allOf(MemoryResourceDefinition.Attribute.class), EnumSet.allOf(OffHeapMemoryResourceDefinition.Attribute.class)})))) {
            writer.writeStartElement(XMLElement.OFF_HEAP_MEMORY.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, memory, (Iterable<? extends Attribute>)attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(ExpirationResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(expiration = cache.get(ExpirationResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(ExpirationResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.EXPIRATION.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, expiration, (Iterable<? extends Attribute>)attributes2);
            writer.writeEndElement();
        }
        EnumSet<StoreResourceDefinition.Attribute> storeAttributes = EnumSet.complementOf(EnumSet.of(StoreResourceDefinition.Attribute.PROPERTIES));
        if (cache.hasDefined(CustomStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(CustomStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, CustomStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, StoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(FileStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(FileStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.FILE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, FileStoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, StoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(JDBCStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(JDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, StoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, XMLElement.TABLE, store, StringTableResourceDefinition.PATH, StringTableResourceDefinition.Attribute.PREFIX);
            writer.writeEndElement();
        }
        if (cache.hasDefined(RemoteStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(RemoteStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.REMOTE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, RemoteStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, StoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(HotRodStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(HotRodStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.HOTROD_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, HotRodStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, StoreResourceDefinition.DeprecatedAttribute.class);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(PartitionHandlingResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(partitionHandling = cache.get(PartitionHandlingResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(PartitionHandlingResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.PARTITION_HANDLING.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, partitionHandling, attributes);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StateTransferResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(stateTransfer = cache.get(StateTransferResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(StateTransferResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.STATE_TRANSFER.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, stateTransfer, attributes);
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupsResourceDefinition.PATH.getKeyValuePair()) && (backups = cache.get(BackupsResourceDefinition.PATH.getKeyValuePair())).hasDefined(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            writer.writeStartElement(XMLElement.BACKUPS.getLocalName());
            for (Property property : backups.get(BackupResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(XMLElement.BACKUP.getLocalName());
                writer.writeAttribute(XMLAttribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                InfinispanSubsystemXMLWriter.writeAttributes(writer, backup, BackupResourceDefinition.Attribute.class);
                InfinispanSubsystemXMLWriter.writeAttributes(writer, backup, BackupResourceDefinition.DeprecatedAttribute.class);
                EnumSet<BackupResourceDefinition.TakeOfflineAttribute> takeOfflineAttributes = EnumSet.allOf(BackupResourceDefinition.TakeOfflineAttribute.class);
                if (InfinispanSubsystemXMLWriter.hasDefined(backup, takeOfflineAttributes)) {
                    writer.writeStartElement(XMLElement.TAKE_OFFLINE.getLocalName());
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, backup, takeOfflineAttributes);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreTable(XMLExtendedStreamWriter writer, XMLElement element, ModelNode store, PathElement path, Attribute prefixAttribute) throws XMLStreamException {
        if (store.hasDefined(path.getKeyValuePair())) {
            ModelNode table = store.get(path.getKeyValuePair());
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, table, TableResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, table, prefixAttribute);
            for (TableResourceDefinition.ColumnAttribute attribute : EnumSet.allOf(TableResourceDefinition.ColumnAttribute.class)) {
                if (!table.hasDefined(attribute.getName())) continue;
                ModelNode column = table.get(attribute.getName());
                writer.writeStartElement(attribute.getDefinition().getXmlName());
                InfinispanSubsystemXMLWriter.writeAttribute(writer, column, attribute.getColumnName());
                InfinispanSubsystemXMLWriter.writeAttribute(writer, column, attribute.getColumnType());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static void writeStoreElements(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        EnumSet<StoreWriteBehindResourceDefinition.Attribute> attributes;
        ModelNode writeBehind;
        if (store.hasDefined(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(writeBehind = store.get(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(StoreWriteBehindResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.WRITE_BEHIND.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, writeBehind, attributes);
            writer.writeEndElement();
        }
        InfinispanSubsystemXMLWriter.writeElement(writer, store, StoreResourceDefinition.Attribute.PROPERTIES);
    }

    private static boolean hasDefined(ModelNode model, Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!model.hasDefined(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            InfinispanSubsystemXMLWriter.writeAttribute(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsElement((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static <P extends ThreadPoolDefinition & ResourceDefinitionProvider> void writeThreadPoolElements(XMLElement element, P pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        if (container.get(((ResourceDefinitionProvider)pool).getPathElement().getKey()).hasDefined(((ResourceDefinitionProvider)pool).getPathElement().getValue())) {
            ModelNode threadPool = container.get(((ResourceDefinitionProvider)pool).getPathElement().getKeyValuePair());
            List<Attribute> attributes = Arrays.asList(pool.getMinThreads(), pool.getMaxThreads(), pool.getQueueLength(), pool.getKeepAliveTime());
            if (InfinispanSubsystemXMLWriter.hasDefined(threadPool, attributes)) {
                writer.writeStartElement(element.getLocalName());
                InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, attributes);
                writer.writeEndElement();
            }
        }
    }

    private static <P extends ScheduledThreadPoolDefinition & ResourceDefinitionProvider> void writeScheduledThreadPoolElements(XMLElement element, P pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        if (container.get(((ResourceDefinitionProvider)pool).getPathElement().getKey()).hasDefined(((ResourceDefinitionProvider)pool).getPathElement().getValue())) {
            ModelNode threadPool = container.get(((ResourceDefinitionProvider)pool).getPathElement().getKeyValuePair());
            List<Attribute> attributes = Arrays.asList(pool.getMinThreads(), pool.getKeepAliveTime());
            if (InfinispanSubsystemXMLWriter.hasDefined(threadPool, attributes)) {
                writer.writeStartElement(element.getLocalName());
                InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, attributes);
                writer.writeEndElement();
            }
        }
    }
}

