/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.GroupMembershipMergeEvent;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupMemberFactory;

public class EmbeddedCacheManagerGroup<A extends Comparable<A>, M extends GroupMember<A>>
implements CacheContainerGroup {
    private final Group<A, M> group;
    private final Function<M, CacheContainerGroupMember> wrapper;
    private final CacheContainerGroupMemberFactory factory;
    private final CacheContainerGroupMember localMember;

    public EmbeddedCacheManagerGroup(EmbeddedCacheManagerGroupConfiguration<A, M> configuration) {
        this.group = configuration.getGroup();
        this.factory = new EmbeddedCacheManagerGroupMemberFactory(configuration);
        this.wrapper = configuration.getAddressWrapper().compose(GroupMember::getAddress).andThen(arg_0 -> ((CacheContainerGroupMemberFactory)this.factory).createGroupMember(arg_0));
        this.localMember = this.wrapper.apply((GroupMember)this.group.getLocalMember());
    }

    public String getName() {
        return this.group.getName();
    }

    public CacheContainerGroupMember getLocalMember() {
        return this.localMember;
    }

    public GroupMembership<CacheContainerGroupMember> getMembership() {
        return this.wrap(this.group.getMembership());
    }

    public boolean isSingleton() {
        return this.group.isSingleton();
    }

    public Registration register(final GroupMembershipListener<CacheContainerGroupMember> listener) {
        return this.group.register((Object)new GroupMembershipListener<M>(){

            public void updated(GroupMembershipEvent<M> event) {
                listener.updated((GroupMembershipEvent)new CacheContainerGroupMembershipEvent(event));
            }

            public void split(GroupMembershipEvent<M> event) {
                listener.split((GroupMembershipEvent)new CacheContainerGroupMembershipEvent(event));
            }

            public void merged(GroupMembershipMergeEvent<M> event) {
                listener.merged((GroupMembershipMergeEvent)new CacheContainerGroupMembershipMergeEvent(event));
            }
        });
    }

    @Override
    public CacheContainerGroupMemberFactory getGroupMemberFactory() {
        return this.factory;
    }

    GroupMembership<CacheContainerGroupMember> wrap(GroupMembership<M> membership) {
        return new CacheGroupMembership(membership, this.wrapper);
    }

    static class CacheGroupMembership<A extends Comparable<A>, M extends GroupMember<A>>
    implements GroupMembership<CacheContainerGroupMember> {
        private final GroupMembership<M> membership;
        private final List<CacheContainerGroupMember> members;
        private final CacheContainerGroupMember coordinator;

        CacheGroupMembership(GroupMembership<M> membership, Function<M, CacheContainerGroupMember> wrapper) {
            this.membership = membership;
            this.members = membership.getMembers().stream().map(wrapper).collect(Collectors.toUnmodifiableList());
            this.coordinator = wrapper.apply((GroupMember)membership.getCoordinator());
        }

        public CacheContainerGroupMember getCoordinator() {
            return this.coordinator;
        }

        public List<CacheContainerGroupMember> getMembers() {
            return this.members;
        }

        public int hashCode() {
            return this.membership.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheGroupMembership)) {
                return false;
            }
            CacheGroupMembership membership = (CacheGroupMembership)object;
            return this.membership.equals(membership.membership);
        }

        public String toString() {
            return this.membership.toString();
        }
    }

    class CacheContainerGroupMembershipMergeEvent
    extends CacheContainerGroupMembershipEvent
    implements GroupMembershipMergeEvent<CacheContainerGroupMember> {
        private final List<GroupMembership<CacheContainerGroupMember>> partitions;

        CacheContainerGroupMembershipMergeEvent(GroupMembershipMergeEvent<M> event) {
            super(event);
            this.partitions = event.getPartitions().stream().map(EmbeddedCacheManagerGroup.this::wrap).collect(Collectors.toUnmodifiableList());
        }

        public List<GroupMembership<CacheContainerGroupMember>> getPartitions() {
            return this.partitions;
        }
    }

    class CacheContainerGroupMembershipEvent
    implements GroupMembershipEvent<CacheContainerGroupMember> {
        private final GroupMembership<CacheContainerGroupMember> previousMembership;
        private final GroupMembership<CacheContainerGroupMember> currentMembership;

        CacheContainerGroupMembershipEvent(GroupMembershipEvent<M> event) {
            this.previousMembership = EmbeddedCacheManagerGroup.this.wrap(event.getPreviousMembership());
            this.currentMembership = EmbeddedCacheManagerGroup.this.wrap(event.getCurrentMembership());
        }

        public GroupMembership<CacheContainerGroupMember> getPreviousMembership() {
            return this.previousMembership;
        }

        public GroupMembership<CacheContainerGroupMember> getCurrentMembership() {
            return this.currentMembership;
        }
    }
}

