/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.affinity.GroupMemberAffinityConfiguration;

public class NaryGroupMemberAffinity<I>
implements Function<I, List<CacheContainerGroupMember>> {
    private final KeyDistribution distribution;
    private final CacheContainerGroupMemberFactory factory;
    private final CacheContainerGroupMember localMember;

    public NaryGroupMemberAffinity(GroupMemberAffinityConfiguration<I> configuration) {
        this(configuration.getCache(), configuration.getGroup());
    }

    public NaryGroupMemberAffinity(Cache<? extends Key<I>, ?> cache, CacheContainerGroup group) {
        this(KeyDistribution.forCache(cache), group.getGroupMemberFactory(), (CacheContainerGroupMember)group.getLocalMember());
    }

    NaryGroupMemberAffinity(KeyDistribution distribution, CacheContainerGroupMemberFactory factory, CacheContainerGroupMember localMember) {
        this.distribution = distribution;
        this.factory = factory;
        this.localMember = localMember;
    }

    @Override
    public List<CacheContainerGroupMember> apply(I id) {
        LinkedList<CacheContainerGroupMember> members = new LinkedList<CacheContainerGroupMember>();
        boolean locallyOwned = false;
        for (Address address : this.distribution.getOwners((Object)new CacheKey(id))) {
            locallyOwned |= ((Address)this.localMember.getAddress()).equals(address);
            members.add((CacheContainerGroupMember)this.factory.createGroupMember((Comparable)address));
        }
        if (!locallyOwned) {
            members.add(this.localMember);
        }
        return members;
    }
}

