/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import java.util.Optional;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.vertx.AbstractVertxOptionRemoveHandler;
import org.wildfly.extension.vertx.NamedVertxOptions;
import org.wildfly.extension.vertx.VertxSubsystemExtension;

public abstract class AbstractVertxOptionsResourceDefinition
extends SimpleResourceDefinition {
    static final RuntimeCapability<Void> VERTX_OPTIONS_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.vertx.options", (boolean)true, NamedVertxOptions.class).build();

    protected AbstractVertxOptionsResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(parameters);
    }

    private static Resource readVertxRootResource(OperationContext context) {
        return context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{VertxSubsystemExtension.SUBSYSTEM_PATH}));
    }

    private static boolean isVertxOptionUsedInternal(Resource vertxResource, String vertxOptionName) {
        return vertxResource.getChildren("vertx").stream().anyMatch(re -> re.getModel().get("option-name").asString().equals(vertxOptionName));
    }

    static boolean isVertxOptionUsed(OperationContext context, String vertxOptionName) {
        Resource vertxResource = AbstractVertxOptionsResourceDefinition.readVertxRootResource(context);
        return AbstractVertxOptionsResourceDefinition.isVertxOptionUsedInternal(vertxResource, vertxOptionName);
    }

    static boolean isAddressResolverUsed(OperationContext context, String addressResolverName) {
        Resource vertxResource = AbstractVertxOptionsResourceDefinition.readVertxRootResource(context);
        Optional<String> vertxOptionName = vertxResource.getChildren("vertx-option").stream().filter(re -> re.getModel().get("address-resolver-option").asString().equals(addressResolverName)).map(Resource.ResourceEntry::getName).findAny();
        return vertxOptionName.isPresent() && AbstractVertxOptionsResourceDefinition.isVertxOptionUsedInternal(vertxResource, vertxOptionName.get());
    }

    protected static class AttrWriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        protected AttrWriteHandler() {
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            return AbstractVertxOptionsResourceDefinition.isVertxOptionUsed(context, context.getCurrentAddressValue());
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        }
    }

    protected static class VertxOptionRemoveHandler
    extends AbstractVertxOptionRemoveHandler {
        protected VertxOptionRemoveHandler() {
        }

        @Override
        protected void doPerform(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceName vertxServiceName = VERTX_OPTIONS_CAPABILITY.getCapabilityServiceName(new String[]{context.getCurrentAddressValue()});
            context.removeService(vertxServiceName);
        }

        @Override
        protected boolean isOptionUsedInRuntime(OperationContext context) {
            return AbstractVertxOptionsResourceDefinition.isVertxOptionUsed(context, context.getCurrentAddressValue());
        }
    }
}

