/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SendDLQNoRouteTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sessionFactory;

    @BeforeEach
    public void setup() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
    }

    @Test
    @Timeout(value=20L)
    public void testDLQNoRoute() throws Exception {
        AddressSettings addressSettings = new AddressSettings().setSendToDLAOnNoRoute(true);
        addressSettings.setDeadLetterAddress(SimpleString.of((String)"DLA"));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AddressInfo info = new AddressInfo(SimpleString.of((String)"info")).addRoutingType(RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
        AddressInfo dla = new AddressInfo(SimpleString.of((String)"DLA")).addRoutingType(RoutingType.MULTICAST);
        this.server.addAddressInfo(dla);
        ServerLocator locator = this.createNonHALocator(false);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(true, true);
        ClientProducer producer = session.createProducer("info");
        producer.send((Message)session.createMessage(true));
        session.commit();
    }
}

