/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireTestOnRestartTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        AddressSettings setting = new AddressSettings().setExpiryAddress(SimpleString.of((String)"exp")).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setPageSizeBytes(102400).setMaxSizeBytes(204800L).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
        this.server.getConfiguration().setJournalSyncNonTransactional(false);
        this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server.getConfiguration().setJournalSyncTransactional(false);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)setting);
        this.server.start();
    }

    @Test
    public void testRestartWithExpireAndPaging() throws Exception {
        ClientMessage msg;
        int i;
        ClientMessage message;
        int i2;
        int NUMBER_OF_EXPIRED_MESSAGES = 1000;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnDurableSend(false);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(true, true);
        session.createQueue(QueueConfiguration.of((String)"test"));
        session.createQueue(QueueConfiguration.of((String)"exp"));
        ClientProducer prod = session.createProducer("test");
        for (i2 = 0; i2 < 10; ++i2) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[10240]);
            message.putStringProperty("expiryStatus", "not Expiring");
            prod.send((Message)message);
        }
        for (i2 = 0; i2 < NUMBER_OF_EXPIRED_MESSAGES; ++i2) {
            message = session.createMessage(true);
            message.putIntProperty("i", i2);
            message.putStringProperty("expiryStatus", "Will Expire");
            message.getBodyBuffer().writeBytes(new byte[10240]);
            message.setExpiration(System.currentTimeMillis() + 1000L);
            prod.send((Message)message);
        }
        session.commit();
        session.close();
        this.server.stop();
        this.server.getConfiguration().setMessageExpiryScanPeriod(1L);
        Thread.sleep(1500L);
        this.server.start();
        Queue queue = this.server.locateQueue(SimpleString.of((String)"test"));
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false);
        ClientConsumer cons = session.createConsumer("test");
        session.start();
        for (i = 0; i < 10; ++i) {
            msg = cons.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        Assertions.assertNull((Object)cons.receiveImmediate());
        cons.close();
        cons = session.createConsumer("exp");
        for (i = 0; i < NUMBER_OF_EXPIRED_MESSAGES; ++i) {
            msg = cons.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        int extras = 0;
        while ((msg = cons.receiveImmediate()) != null) {
            logger.debug("{}", (Object)msg);
            ++extras;
        }
        Assertions.assertEquals((int)0, (int)extras, (String)"Received extra messages on expire address");
        session.commit();
        session.close();
        locator.close();
        Wait.assertFalse(() -> ((PagingStore)queue.getPagingStore()).isPaging(), (long)5000L, (long)100L);
    }
}

