/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FailoverWithDivertTest
extends FailoverTestBase {
    private static final String DIVERT_ADDRESS = "jms.queue.testQueue";
    private static final String DIVERT_FORWARD_ADDRESS = "jms.queue.divertedQueue";
    private ClientSessionFactoryInternal sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
        this.primaryConfig.setJournalFileSize(10240000);
        this.backupConfig.setJournalFileSize(10240000);
        this.addQueue(this.primaryConfig, DIVERT_ADDRESS, DIVERT_ADDRESS);
        this.addQueue(this.primaryConfig, DIVERT_FORWARD_ADDRESS, DIVERT_FORWARD_ADDRESS);
        this.addDivert(this.primaryConfig, DIVERT_ADDRESS, DIVERT_FORWARD_ADDRESS, false);
        this.addDivert(this.backupConfig, DIVERT_ADDRESS, DIVERT_FORWARD_ADDRESS, false);
    }

    private void addQueue(Configuration serverConfig, String address, String name) {
        List addrConfigs = serverConfig.getAddressConfigurations();
        CoreAddressConfiguration addrCfg = new CoreAddressConfiguration();
        addrCfg.setName(address);
        addrCfg.addRoutingType(RoutingType.ANYCAST);
        addrCfg.addQueueConfiguration(QueueConfiguration.of((String)name).setAddress(address));
        addrConfigs.add(addrCfg);
    }

    private void addDivert(Configuration serverConfig, String source, String target, boolean exclusive) {
        List divertConfigs = serverConfig.getDivertConfigurations();
        DivertConfiguration newDivert = new DivertConfiguration();
        newDivert.setName("myDivert");
        newDivert.setAddress(source);
        newDivert.setForwardingAddress(target);
        newDivert.setExclusive(exclusive);
        divertConfigs.add(newDivert);
    }

    @Test
    public void testUniqueIDsWithDivert() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "localhost");
        TransportConfiguration tc = FailoverWithDivertTest.createTransportConfiguration(true, false, params);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc})).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(-1);
        this.sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
        int minLarge = locator.getMinLargeMessageSize();
        ClientSession session = this.sf.createSession(false, false);
        this.addClientSession(session);
        session.start();
        int num = 100;
        ClientProducer producer = session.createProducer(DIVERT_ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createLargeMessage(session, 2 * minLarge);
            producer.send((Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(DIVERT_ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage receivedFromSourceQueue = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedFromSourceQueue);
            receivedFromSourceQueue.acknowledge();
        }
        session.commit();
        this.crash(session);
        ClientConsumer consumer1 = session.createConsumer(DIVERT_FORWARD_ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage receivedFromTargetQueue = consumer1.receive(5000L);
            Assertions.assertNotNull((Object)receivedFromTargetQueue);
            receivedFromTargetQueue.acknowledge();
        }
        session.commit();
    }

    private ClientMessage createLargeMessage(ClientSession session, int largeSize) {
        ClientMessage message = session.createMessage(true);
        ActiveMQBuffer bodyBuffer = message.getBodyBuffer();
        int propSize = 10240;
        while (bodyBuffer.writerIndex() < largeSize) {
            byte[] prop = new byte[10240];
            bodyBuffer.writeBytes(prop);
        }
        return message;
    }
}

