/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCleanupWhileReplicaCatchupTest
extends FailoverTestBase {
    private static final int NUMBER_OF_WORKERS = 5;
    private static final int NUMBER_OF_RESTARTS = 5;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    volatile boolean running = true;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        HashMap<String, AddressSettings> conf = new HashMap<String, AddressSettings>();
        AddressSettings as = new AddressSettings().setMaxSizeBytes(2048L).setPageSizeBytes(1024).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        conf.put(ADDRESS.toString(), as);
        return this.createInVMFailoverServer(realFiles, configuration, 1024, 2048, conf, nodeManager, id);
    }

    @Test
    @Timeout(value=160L)
    public void testPageCleanup() throws Throwable {
        int i;
        Worker[] workers = new Worker[5];
        for (i = 0; i < 5; ++i) {
            this.primaryServer.getServer().addAddressInfo(new AddressInfo("WORKER_" + i).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
            this.primaryServer.getServer().createQueue(QueueConfiguration.of((String)("WORKER_" + i)).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
            workers[i] = new Worker("WORKER_" + i);
            workers[i].start();
        }
        for (i = 0; i < 5; ++i) {
            logger.debug("Starting replica {}", (Object)i);
            this.backupServer.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer.getServer()).isReplicaSync());
            this.backupServer.stop();
        }
        this.running = false;
        for (Worker worker : workers) {
            worker.join();
        }
        for (Worker worker : workers) {
            if (worker.throwable == null) continue;
            throw new RuntimeException("Worker " + worker.queueName + " failed", worker.throwable);
        }
        for (Worker worker : workers) {
            PagingStoreImpl storeImpl = (PagingStoreImpl)worker.queue.getPagingStore();
            Wait.assertFalse(() -> ((PagingStoreImpl)storeImpl).isPaging(), (long)5000L, (long)100L);
        }
    }

    class Worker
    extends Thread {
        final String queueName;
        final Queue queue;
        volatile Throwable throwable;

        Worker(String queue) {
            super("Worker on queue " + queue + " for test on PageCleanupWhileReplicaCatchupTest");
            this.queueName = queue;
            this.queue = PageCleanupWhileReplicaCatchupTest.this.primaryServer.getServer().locateQueue(this.queueName);
        }

        @Override
        public void run() {
            try {
                ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
                try (Connection connection = factory.createConnection();){
                    Session session = connection.createSession(false, 1);
                    connection.start();
                    jakarta.jms.Queue jmsQueue = session.createQueue(this.queueName);
                    MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
                    MessageProducer producer = session.createProducer((Destination)jmsQueue);
                    while (PageCleanupWhileReplicaCatchupTest.this.running) {
                        int i;
                        this.queue.getPagingStore().startPaging();
                        for (i = 0; i < 10; ++i) {
                            producer.send((Message)session.createTextMessage("hello " + i));
                        }
                        for (i = 0; i < 10; ++i) {
                            Assertions.assertNotNull((Object)consumer.receive(5000L));
                        }
                        Thread.sleep(500L);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.out);
                this.throwable = e;
            }
        }
    }
}

