/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSLVQTest
extends MultiprotocolJMSClientTestSupport {
    private static final String NORMAL_QUEUE_NAME = "NORMAL";
    private static final String LVQ_QUEUE_NAME = "LVQ";
    private static final String LVQ_CUSTOM_KEY_QUEUE_NAME = "LVQ_CUSTOM_KEY_QUEUE";
    private static final String CUSTOM_KEY = "KEY";

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(false);
        server.getConfiguration().setMessageExpiryScanPeriod(1000L);
        server.getAddressSettingsRepository().addMatch(NORMAL_QUEUE_NAME, (Object)new AddressSettings());
        server.getAddressSettingsRepository().addMatch(LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true));
        server.getAddressSettingsRepository().addMatch(LVQ_CUSTOM_KEY_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultLastValueKey(SimpleString.of((String)CUSTOM_KEY)));
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NORMAL_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NORMAL_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)LVQ_CUSTOM_KEY_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)LVQ_CUSTOM_KEY_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testLVQAMQPProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    public void testLVQCoreProducerCoreConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.CoreConnection);
    }

    @Test
    public void testLVQCoreProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    public void testLVQAMQPProducerCoreConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    public void testLVQOpenWireProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQCoreProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQOpenWireProducerCoreConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.CoreConnection);
    }

    @Test
    public void testLVQAMQPProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQOpenWireProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQDefaultKey(producerConnectionSupplier, consumerConnectionSupplier);
        this.testLVQCustomKey(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testLVQDefaultKey(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQ(producerConnectionSupplier, consumerConnectionSupplier, LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
    }

    public void testLVQCustomKey(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQ(producerConnectionSupplier, consumerConnectionSupplier, LVQ_CUSTOM_KEY_QUEUE_NAME, CUSTOM_KEY);
    }

    public void testLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws Exception {
        this.sendLVQ(producerConnectionSupplier, queueName, lastValueKey);
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, queueName, lastValueKey);
    }

    private void receiveLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)CUSTOM_KEY, (Object)msg.getStringProperty(lastValueKey));
            Assertions.assertEquals((Object)"how are you", (Object)msg.getText());
            consumer.close();
        }
    }

    private void sendLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection producerConnection = producerConnectionSupplier.createConnection();){
            Session producerSession = producerConnection.createSession(false, 1);
            Queue queue1 = producerSession.createQueue(queueName);
            MessageProducer p = producerSession.createProducer(null);
            TextMessage message1 = producerSession.createTextMessage();
            message1.setStringProperty(lastValueKey, CUSTOM_KEY);
            message1.setText("hello");
            p.send((Destination)queue1, (Message)message1);
            TextMessage message2 = producerSession.createTextMessage();
            message2.setStringProperty(lastValueKey, CUSTOM_KEY);
            message2.setText("how are you");
            p.send((Destination)queue1, (Message)message2);
        }
    }

    @Test
    public void testNonDestructiveWithSelector() throws Exception {
        String MY_QUEUE = RandomUtil.randomString();
        boolean NON_DESTRUCTIVE = true;
        this.server.createQueue(QueueConfiguration.of((String)MY_QUEUE).setRoutingType(RoutingType.ANYCAST).setNonDestructive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier = this.CoreConnection;
        Connection consumerConnection1 = connectionSupplier.createConnection();
        Session consumerSession1 = consumerConnection1.createSession(false, 1);
        Queue myQueue = consumerSession1.createQueue(MY_QUEUE);
        MessageConsumer consumer1 = consumerSession1.createConsumer((Destination)myQueue);
        consumerConnection1.start();
        Connection consumerConnection2 = connectionSupplier.createConnection();
        Session consumerSession2 = consumerConnection2.createSession(false, 1);
        myQueue = consumerSession2.createQueue(MY_QUEUE);
        MessageConsumer consumer2 = consumerSession2.createConsumer((Destination)myQueue, "foo='bar'");
        Connection producerConnection = connectionSupplier.createConnection();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer p = producerSession.createProducer((Destination)myQueue);
        for (int i = 0; i < 1000; ++i) {
            TextMessage m = producerSession.createTextMessage();
            m.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), "abc");
            p.send((Message)m);
            Assertions.assertNotNull((Object)consumer1.receive(500L));
        }
    }
}

