/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSServerPropertyConfigTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigViaBrokerPropertiesSystemProperty() throws Exception {
        EmbeddedActiveMQ server = new EmbeddedActiveMQ();
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setJournalDirectory(new File(this.getTestDir(), "./journal").getAbsolutePath()).setPagingDirectory(new File(this.getTestDir(), "./paging").getAbsolutePath()).setLargeMessagesDirectory(new File(this.getTestDir(), "./largemessages").getAbsolutePath()).setBindingsDirectory(new File(this.getTestDir(), "./bindings").getAbsolutePath()).setPersistenceEnabled(true);
        File bindingsDir = new File(configuration.getBindingsDirectory());
        bindingsDir.mkdirs();
        File propertiesInBindingsDir = new File(bindingsDir, "broker.properties");
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(propertiesInBindingsDir)));){
            out.println("gracefulShutdownTimeout=-3");
        }
        System.setProperty("broker.properties", propertiesInBindingsDir.getAbsolutePath());
        try {
            server.setConfiguration((Configuration)configuration);
            server.start();
            Assertions.assertEquals((long)-3L, (long)server.getActiveMQServer().getConfiguration().getGracefulShutdownTimeout());
        }
        finally {
            System.getProperties().remove("broker.properties");
            server.stop();
        }
    }

    @Test
    public void testConfigViaBrokerPropertiesFromClasspath() throws Exception {
        EmbeddedActiveMQ server = new EmbeddedActiveMQ();
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setJournalDirectory(new File(this.getTestDir(), "./journal").getAbsolutePath()).setPagingDirectory(new File(this.getTestDir(), "./paging").getAbsolutePath()).setLargeMessagesDirectory(new File(this.getTestDir(), "./largemessages").getAbsolutePath()).setBindingsDirectory(new File(this.getTestDir(), "./bindings").getAbsolutePath()).setPersistenceEnabled(true);
        try {
            server.setConfiguration((Configuration)configuration);
            server.start();
            Assertions.assertEquals((long)-2L, (long)server.getActiveMQServer().getConfiguration().getGracefulShutdownTimeout());
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testIgnoreConfigViaBrokerPropertiesFromClasspath() throws Exception {
        EmbeddedActiveMQ server = new EmbeddedActiveMQ();
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setJournalDirectory(new File(this.getTestDir(), "./journal").getAbsolutePath()).setPagingDirectory(new File(this.getTestDir(), "./paging").getAbsolutePath()).setLargeMessagesDirectory(new File(this.getTestDir(), "./largemessages").getAbsolutePath()).setBindingsDirectory(new File(this.getTestDir(), "./bindings").getAbsolutePath()).setPersistenceEnabled(true);
        try {
            server.setPropertiesResourcePath(null);
            server.setConfiguration((Configuration)configuration);
            server.start();
            Assertions.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultGracefulShutdownTimeout(), (long)server.getActiveMQServer().getConfiguration().getGracefulShutdownTimeout());
        }
        finally {
            server.stop();
        }
    }
}

