/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class SecurityManagementTestBase
extends ActiveMQTestBase {
    private ActiveMQServer server;
    @Parameter(index=0)
    public boolean managementRbac = false;

    @Parameters(name="managementRbac={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.setupAndStartActiveMQServer();
    }

    protected abstract ActiveMQServer setupAndStartActiveMQServer() throws Exception;

    @Override
    protected Configuration createDefaultInVMConfig() throws Exception {
        Configuration configuration = super.createDefaultInVMConfig();
        if (this.managementRbac) {
            configuration.setManagementMessageRbac(true);
        }
        return configuration;
    }

    protected void doSendBrokerManagementMessage(String user, String password, boolean expectSuccess) throws Exception {
        this.doSendBrokerManagementMessageForAttribute(user, password, expectSuccess);
    }

    protected void doSendBrokerManagementMessageForAttribute(String user, String password, boolean expectSuccess) throws Exception {
        this.doSendBrokerManagementMessageFor(true, user, password, expectSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendBrokerManagementMessageFor(boolean attribute, String user, String password, boolean expectSuccess) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        try (ClientSessionFactory sf = locator.createSessionFactory();){
            ClientSession session = null;
            session = user == null ? sf.createSession(false, true, true) : sf.createSession(user, password, false, true, true, false, 1);
            session.start();
            ClientRequestor requestor = new ClientRequestor(session, ActiveMQDefaultConfiguration.getDefaultManagementAddress());
            ClientMessage mngmntMessage = session.createMessage(false);
            if (attribute) {
                ManagementHelper.putAttribute((ICoreMessage)mngmntMessage, (String)"broker", (String)"started");
            } else {
                ManagementHelper.putOperationInvocation((ICoreMessage)mngmntMessage, (String)"broker", (String)"enableMessageCounters");
            }
            ClientMessage reply = requestor.request(mngmntMessage, 500L);
            if (expectSuccess) {
                Assertions.assertNotNull((Object)reply);
                Assertions.assertTrue((boolean)ManagementHelper.hasOperationSucceeded((Message)reply), (String)("" + ManagementHelper.getResult((ICoreMessage)reply)));
                if (attribute) {
                    Assertions.assertTrue((boolean)((Boolean)ManagementHelper.getResult((ICoreMessage)reply)), (String)("" + ManagementHelper.getResult((ICoreMessage)reply)));
                }
            } else if (attribute) {
                Assertions.assertNull((Object)reply);
            } else {
                Assertions.assertNotNull((Object)reply);
                Assertions.assertFalse((boolean)ManagementHelper.hasOperationSucceeded((Message)reply), (String)("" + ManagementHelper.getResult((ICoreMessage)reply)));
            }
            requestor.close();
        }
    }
}

