/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigChangeTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Test
    public void testChangeQueueRoutingTypeOnRestart() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig();
        configuration.addAddressSetting("#", new AddressSettings());
        ArrayList<CoreAddressConfiguration> addressConfigurations = new ArrayList<CoreAddressConfiguration>();
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server = this.createServer(true, configuration);
        this.server.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (JMSContext context = connectionFactory.createContext();){
            context.createProducer().send((Destination)context.createQueue("myAddress"), "hello");
        }
        this.server.stop();
        addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.MULTICAST).addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setRoutingType(RoutingType.MULTICAST));
        addressConfigurations.clear();
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server.start();
        Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(SimpleString.of((String)"myAddress")).getRoutingType());
        Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.locateQueue(SimpleString.of((String)"myQueue")).getRoutingType());
        context = connectionFactory.createContext();
        try {
            Message message = context.createSharedDurableConsumer(context.createTopic("myAddress"), "myQueue").receive();
            Assertions.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.server.stop();
    }

    @Test
    public void testChangeQueueFilterOnRestart() throws Exception {
        String filter1 = "x = 'x'";
        String filter2 = "x = 'y'";
        Configuration configuration = this.createDefaultInVMConfig();
        configuration.addAddressSetting("#", new AddressSettings());
        ArrayList<CoreAddressConfiguration> addressConfigurations = new ArrayList<CoreAddressConfiguration>();
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setFilterString("x = 'x'").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server = this.createServer(true, configuration);
        this.server.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (JMSContext context = connectionFactory.createContext();){
            context.createProducer().setProperty("x", "x").send((Destination)context.createQueue("myAddress"), "hello");
        }
        long originalBindingId = this.server.getPostOffice().getBinding(SimpleString.of((String)"myQueue")).getID();
        this.server.stop();
        addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setFilterString("x = 'y'").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.clear();
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server.start();
        Assertions.assertEquals((Object)"x = 'y'", (Object)this.server.locateQueue(SimpleString.of((String)"myQueue")).getFilter().getFilterString().toString());
        try (JMSContext context = connectionFactory.createContext();){
            Message message = context.createConsumer((Destination)context.createQueue("myAddress::myQueue")).receive();
            Assertions.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
        }
        long bindingId = this.server.getPostOffice().getBinding(SimpleString.of((String)"myQueue")).getID();
        Assertions.assertEquals((long)originalBindingId, (long)bindingId, (String)"Ensure the original queue is not destroyed by checking the binding id is the same");
        this.server.stop();
    }

    @Test
    public void bridgeConfigChangesPersist() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        String bridgeName = "bridgeName";
        String queue = "Q1";
        String forward = "Q2";
        session.createQueue(QueueConfiguration.of((String)queue).setAddress(queue).setRoutingType(RoutingType.ANYCAST).setAutoDelete(Boolean.valueOf(false)));
        session.createQueue(QueueConfiguration.of((String)forward).setAddress(forward).setRoutingType(RoutingType.ANYCAST).setAutoDelete(Boolean.valueOf(false)));
        session.close();
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName(bridgeName).setQueueName(queue).setConcurrency(2).setForwardingAddress(forward).setProducerWindowSize(1234).setConfirmationWindowSize(1234).setStaticConnectors(Arrays.asList("connector1", "connector2"));
        this.server.getActiveMQServerControl().addConnector("connector1", "tcp://localhost:61616");
        this.server.getActiveMQServerControl().addConnector("connector2", "tcp://localhost:61616");
        this.server.getActiveMQServerControl().createBridge(bridgeConfiguration.toJSON());
        Assertions.assertEquals((int)2, (int)this.server.getConfiguration().getConnectorConfigurations().size());
        Assertions.assertEquals((int)2, (int)this.server.getActiveMQServerControl().getBridgeNames().length);
        this.server.stop();
        this.server.getConfiguration().getConnectorConfigurations().clear();
        this.server.start();
        Assertions.assertEquals((int)2, (int)this.server.getConfiguration().getConnectorConfigurations().size());
        Assertions.assertEquals((int)2, (int)this.server.getActiveMQServerControl().getBridgeNames().length);
        this.server.getActiveMQServerControl().destroyBridge(bridgeName);
        this.server.getActiveMQServerControl().removeConnector("connector1");
        this.server.getActiveMQServerControl().removeConnector("connector2");
        Assertions.assertEquals((int)0, (int)this.server.getActiveMQServerControl().getBridgeNames().length);
        Assertions.assertEquals((int)0, (int)this.server.getConfiguration().getConnectorConfigurations().size());
        this.server.stop();
        this.server.start();
        Assertions.assertEquals((int)0, (int)this.server.getActiveMQServerControl().getBridgeNames().length);
        Assertions.assertEquals((int)0, (int)this.server.getConfiguration().getConnectorConfigurations().size());
        this.server.stop();
    }
}

