/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.JBossModulesCommandBuilder;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

abstract class AbstractCommandBuilder<T extends AbstractCommandBuilder<T>>
extends JBossModulesCommandBuilder
implements CommandBuilder {
    static final String HOME_DIR = "jboss.home.dir";
    private Path logDir;
    private Path configDir;

    protected AbstractCommandBuilder(Path wildflyHome, String moduleName) {
        this(wildflyHome, null, moduleName);
    }

    protected AbstractCommandBuilder(Path wildflyHome, Jvm jvm, String moduleName) {
        super(wildflyHome, jvm, moduleName);
    }

    public T setUseSecurityManager(boolean useSecMgr) {
        super.setUseSecurityManager(useSecMgr);
        return this.getThis();
    }

    public T addModuleDir(String moduleDir) {
        super.addModuleDir(moduleDir);
        return this.getThis();
    }

    public T addModuleDirs(String ... moduleDirs) {
        super.addModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T addModuleDirs(Iterable<String> moduleDirs) {
        super.addModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T setModuleDirs(Iterable<String> moduleDirs) {
        super.setModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T setModuleDirs(String ... moduleDirs) {
        super.setModuleDirs(moduleDirs);
        return this.getThis();
    }

    public Path getLogDirectory() {
        if (this.logDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "log");
        }
        return this.logDir;
    }

    public T setLogDirectory(String path) {
        if (path == null) {
            this.logDir = null;
            return this.getThis();
        }
        return this.setLogDirectory(Paths.get(path, new String[0]));
    }

    public T setLogDirectory(Path path) {
        if (path == null) {
            this.logDir = null;
        } else {
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.invalidDirectory(path);
            }
            this.logDir = path.toAbsolutePath().normalize();
        }
        return this.getThis();
    }

    public Path getConfigurationDirectory() {
        if (this.configDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "configuration");
        }
        return this.configDir;
    }

    public T setConfigurationDirectory(String path) {
        this.configDir = Environment.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T setConfigurationDirectory(Path path) {
        this.configDir = Environment.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T addServerArgument(String arg) {
        super.addServerArgument(arg);
        return this.getThis();
    }

    public T addServerArguments(String ... args) {
        super.addServerArguments(args);
        return this.getThis();
    }

    public T addServerArguments(Iterable<String> args) {
        super.addServerArguments(args);
        return this.getThis();
    }

    public T setAdminOnly() {
        return (T)this.addServerArgument("--admin-only");
    }

    public T setStartSuspended() {
        return (T)this.addServerArgument("--start-mode=suspend");
    }

    public T setBindAddressHint(String address) {
        this.setSingleServerArg("-b", address);
        return this.getThis();
    }

    public T setBindAddressHint(String interfaceName, String address) {
        if (interfaceName == null) {
            throw LauncherMessages.MESSAGES.nullParam("interfaceName");
        }
        this.setSingleServerArg("-b" + interfaceName, address);
        return this.getThis();
    }

    public T setMulticastAddressHint(String address) {
        this.setSingleServerArg("-u", address);
        return this.getThis();
    }

    public T addPropertiesFile(String file) {
        if (file != null) {
            this.addPropertiesFile(Paths.get(file, new String[0]));
        }
        return this.getThis();
    }

    public T addPropertiesFile(Path file) {
        if (file != null) {
            if (Files.notExists(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathDoesNotExist(file);
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathNotAFile(file);
            }
            this.addServerArg("-P", file.toAbsolutePath().normalize().toString());
        }
        return this.getThis();
    }

    public T setPropertiesFile(String file) {
        Path path = file == null ? null : Paths.get(file, new String[0]);
        return this.setPropertiesFile(path);
    }

    public T setPropertiesFile(Path file) {
        this.serverArgs.remove("-P");
        return this.addPropertiesFile(file);
    }

    @Override
    public abstract Path getJavaHome();

    protected String getLoggingPropertiesArgument(String fileName) {
        return "-Dlogging.configuration=file:" + String.valueOf(this.normalizePath(this.getConfigurationDirectory(), fileName));
    }

    protected String getBootLogArgument(String fileName) {
        return "-Dorg.jboss.boot.log.file=" + String.valueOf(this.normalizePath(this.getLogDirectory(), fileName));
    }

    protected Path normalizePath(String path) {
        return this.environment.resolvePath(path).toAbsolutePath().normalize();
    }

    protected Path normalizePath(Path parent, String path) {
        return parent.resolve(path).toAbsolutePath().normalize();
    }

    public abstract Path getBaseDirectory();

    protected abstract T getThis();

    protected static void addSystemPropertyArg(List<String> cmd, String key, Object value) {
        if (value != null) {
            cmd.add("-D" + key + "=" + String.valueOf(value));
        }
    }
}

