/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractMappingConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -3181156290079915301L;
    private final Function<String, String> mapping;

    public AbstractMappingConfigSourceInterceptor(Function<String, String> mapping) {
        this.mapping = mapping != null ? mapping : Function.identity();
    }

    public AbstractMappingConfigSourceInterceptor(final Map<String, String> mappings) {
        this(new Function<String, String>(){

            @Override
            public String apply(String name) {
                return mappings.getOrDefault(name, name);
            }
        });
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = namesIterator.next();
            names.add(name);
            String mappedName = this.mapping.apply(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    protected Function<String, String> getMapping() {
        return this.mapping;
    }
}

