/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.modules.Main;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogRecord;
import org.jboss.modules.log.ModuleLogger;

public final class JDKModuleLogger
implements ModuleLogger {
    private static final Level TRACE;
    private static final Level DEBUG;
    private static final Level WARN;
    private final Logger logger;
    private final Logger defineLogger;

    @Deprecated
    public JDKModuleLogger(Logger logger, Logger defineLogger) {
        this.logger = logger;
        this.defineLogger = defineLogger;
    }

    public JDKModuleLogger(String category) {
        this(Logger.getLogger(category), Logger.getLogger(category + ".define"));
    }

    public JDKModuleLogger() {
        this("org.jboss.modules");
    }

    private void doLog(Logger logger, Level level, String str, Throwable t) {
        try {
            ModuleLogRecord rec = new ModuleLogRecord(level, str);
            rec.setLoggerName(logger.getName());
            if (t != null) {
                rec.setThrown(t);
            }
            logger.log(rec);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(String message) {
        this.doLog(this.logger, TRACE, message, null);
    }

    @Override
    public void trace(String format, Object arg1) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1), null);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1, arg2), null);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1, arg2, arg3), null);
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, args), null);
        }
    }

    @Override
    public void trace(Throwable t, String message) {
        this.doLog(this.logger, TRACE, message, t);
    }

    @Override
    public void trace(Throwable t, String format, Object arg1) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1, arg2), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, arg1, arg2, arg3), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... args) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(this.logger, TRACE, String.format(format, args), t);
        }
    }

    @Override
    public void greeting() {
        this.doLog(this.logger, Level.INFO, String.format("JBoss Modules version %s", Main.getVersionString()), null);
    }

    @Override
    public void moduleDefined(String name, ModuleLoader moduleLoader) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(this.logger, DEBUG, String.format("Module %s defined by %s", name, moduleLoader), null);
        }
    }

    @Override
    public void classDefineFailed(Throwable throwable, String className, Module module) {
        if (this.defineLogger.isLoggable(WARN)) {
            this.doLog(this.defineLogger, WARN, String.format("Failed to define class %s in %s", className, module), throwable);
        }
    }

    @Override
    public void classDefined(String name, Module module) {
        if (this.defineLogger.isLoggable(TRACE)) {
            this.doLog(this.defineLogger, TRACE, String.format("Defined class %s in %s", name, module), null);
        }
    }

    static {
        Level warn;
        Level debug;
        Level trace;
        try {
            trace = Level.parse("TRACE");
        }
        catch (IllegalArgumentException ignored) {
            trace = Level.FINEST;
        }
        try {
            debug = Level.parse("DEBUG");
        }
        catch (IllegalArgumentException ignored) {
            debug = Level.FINE;
        }
        try {
            warn = Level.parse("WARN");
        }
        catch (IllegalArgumentException ignored) {
            warn = Level.WARNING;
        }
        TRACE = trace;
        DEBUG = debug;
        WARN = warn;
    }
}

