/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public interface SearchIndexIdentifierContext
extends EventContextProvider {
    public static final DslConverter<String, String> RAW_DSL_CONVERTER = DslConverter.passThrough(String.class);
    public static final ProjectionConverter<String, String> RAW_PROJECTION_CONVERTER = ProjectionConverter.passThrough(String.class);

    public EventContext relativeEventContext();

    default public DslConverter<?, String> dslConverter(ValueModel valueModel) {
        switch (valueModel) {
            case INDEX: 
            case RAW: {
                return RAW_DSL_CONVERTER;
            }
            case STRING: {
                return this.parserDslConverter();
            }
        }
        return this.mappingDslConverter();
    }

    public DslConverter<?, String> mappingDslConverter();

    @Incubating
    public DslConverter<?, String> parserDslConverter();

    public ProjectionConverter<String, ?> mappingProjectionConverter();
}

