/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces;

import jakarta.faces.CurrentThreadToServletContext;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinderInstance;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "jakarta.faces.application.ApplicationFactory";
    public static final String CLIENT_WINDOW_FACTORY = "jakarta.faces.lifecycle.ClientWindowFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "jakarta.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "jakarta.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "jakarta.faces.context.FacesContextFactory";
    public static final String FACELET_CACHE_FACTORY = "jakarta.faces.view.facelets.FaceletCacheFactory";
    public static final String FLASH_FACTORY = "jakarta.faces.context.FlashFactory";
    public static final String FLOW_HANDLER_FACTORY = "jakarta.faces.flow.FlowHandlerFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "jakarta.faces.context.PartialViewContextFactory";
    public static final String VISIT_CONTEXT_FACTORY = "jakarta.faces.component.visit.VisitContextFactory";
    public static final String LIFECYCLE_FACTORY = "jakarta.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "jakarta.faces.render.RenderKitFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "jakarta.faces.view.ViewDeclarationLanguageFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "jakarta.faces.view.facelets.TagHandlerDelegateFactory";
    public static final String SEARCH_EXPRESSION_CONTEXT_FACTORY = "jakarta.faces.component.search.SearchExpressionContextFactory";
    static final CurrentThreadToServletContext FACTORIES_CACHE = new CurrentThreadToServletContext();

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        boolean create = !"com.sun.faces.ServletContextFacesContextFactory".equals(factoryName);
        FactoryFinderInstance factoryFinder = FACTORIES_CACHE.getFactoryFinder(create);
        return factoryFinder != null ? factoryFinder.getFactory(factoryName) : null;
    }

    public static void setFactory(String factoryName, String implName) {
        FACTORIES_CACHE.getFactoryFinder().addFactory(factoryName, implName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseFactories() throws FacesException {
        CurrentThreadToServletContext currentThreadToServletContext = FACTORIES_CACHE;
        synchronized (currentThreadToServletContext) {
            if (!FactoryFinder.FACTORIES_CACHE.factoryFinderMap.isEmpty()) {
                FACTORIES_CACHE.getFactoryFinder().releaseFactories();
            }
            FACTORIES_CACHE.removeFactoryFinder();
        }
    }

    private static void reInitializeFactoryManager() {
        FACTORIES_CACHE.resetSpecialInitializationCaseFlags();
    }
}

