/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.split.MultiSplitter;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.keyed.KeyedMulti;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.helpers.KeyMultiUtils;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class StreamTransformerMediator
extends AbstractMediator {
    Function<Multi<? extends Message<?>>, Multi<? extends Message<?>>> function;
    private Multi<? extends Message<?>> publisher;
    private final Map<String, Multi<? extends Message<?>>> outgoingPublisherMap = new HashMap();

    public StreamTransformerMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE && configuration.production() == MediatorConfiguration.Production.STREAM_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && configuration.production() == MediatorConfiguration.Production.STREAM_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.KEYED_MULTI && configuration.production() == MediatorConfiguration.Production.STREAM_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.KEYED_MULTI_MESSAGE && configuration.production() == MediatorConfiguration.Production.STREAM_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE && configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.KEYED_MULTI && configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.KEYED_MULTI_MESSAGE && configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
    }

    @Override
    public void connectToUpstream(Multi<? extends Message<?>> publisher) {
        Objects.requireNonNull(this.function);
        Multi<? extends Message<?>> converted = this.convert(publisher);
        this.publisher = this.decorate(this.function.apply(converted));
    }

    @Override
    public Multi<? extends Message<?>> getStream() {
        Objects.requireNonNull(this.publisher);
        return this.publisher;
    }

    @Override
    public Multi<? extends Message<?>> getStream(String outgoing) {
        if (this.configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_MESSAGE || this.configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_PAYLOAD) {
            return this.outgoingPublisherMap.get(outgoing);
        }
        return super.getStream(outgoing);
    }

    @Override
    public boolean isConnected() {
        return this.publisher != null;
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.consumption()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfMessages();
                    break;
                }
                if (this.configuration.usesReactiveStreams()) {
                    this.processMethodConsumingAReactiveStreamsPublisherOfMessages();
                    break;
                }
                if (this.configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_MESSAGE) {
                    this.processMethodConsumingAPublisherOfPayloadAndProducingSplitMultiOfMessages();
                    break;
                }
                this.processMethodConsumingAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfPayload();
                    break;
                }
                if (this.configuration.usesReactiveStreams()) {
                    this.processMethodConsumingAReactiveStreamsPublisherOfPayload();
                    break;
                }
                if (this.configuration.production() == MediatorConfiguration.Production.SPLIT_MULTI_OF_PAYLOAD) {
                    this.processMethodConsumingAPublisherOfPayloadAndProducingSplitMulti();
                    break;
                }
                this.processMethodConsumingAPublisherOfPayload();
                break;
            }
            case KEYED_MULTI: {
                this.processMethodConsumingAPublisherOfKeyValue();
                break;
            }
            case KEYED_MULTI_MESSAGE: {
                this.processMethodConsumingAPublisherOfKeyValueMessage();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedConsumption(this.configuration.consumption());
            }
        }
        assert (this.function != null);
    }

    private void processMethodConsumingAPublisherBuilderOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            PublisherBuilder argument = ReactiveStreams.fromPublisher((Publisher)AdaptersToReactiveStreams.publisher(multi));
            PublisherBuilder result = (PublisherBuilder)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)result.buildRs()));
        };
    }

    private void processMethodConsumingAReactiveStreamsPublisherOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Publisher<? extends Message<?>> argument = this.convertToDesiredReactiveStreamPublisherType(multi);
            Publisher result = (Publisher)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)result));
        };
    }

    private void processMethodConsumingAPublisherOfPayloadAndProducingSplitMultiOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Flow.Publisher<? extends Message<?>> argument = this.convertToDesiredPublisherType(multi);
            MultiSplitter result = this.fillSplitsOfMessages(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return upstream;
        };
    }

    private <T extends Message<?>, K extends Enum<K>> MultiSplitter<T, K> fillSplitsOfMessages(Flow.Publisher<T> argument) {
        MultiSplitter result = (MultiSplitter)this.invoke(argument);
        Map keyChannelMappings = this.findKeyOutgoingChannelMappings((Enum[])result.keyType().getEnumConstants());
        keyChannelMappings.forEach((key, outgoing) -> {
            Multi m = result.get(key).onItem().transformToUni(u -> Uni.createFrom().item(u)).concatenate(true);
            this.outgoingPublisherMap.put((String)outgoing, (Multi<Message<?>>)m);
        });
        return result;
    }

    private <K extends Enum<K>> Map<K, String> findKeyOutgoingChannelMappings(K[] enumConstants) {
        List outgoings = this.configuration.getOutgoings();
        if (outgoings.size() != enumConstants.length) {
            throw ProviderExceptions.ex.outgoingsDoesNotMatchMultiSplitterTarget(this.getMethodAsString(), outgoings.size(), enumConstants.length);
        }
        HashMap<K, String> mappings = new HashMap<K, String>();
        for (String outgoing : outgoings) {
            for (K key : enumConstants) {
                if (!outgoing.equalsIgnoreCase(((Enum)key).toString())) continue;
                mappings.put(key, outgoing);
            }
        }
        if (mappings.keySet().containsAll(Arrays.asList(enumConstants)) && mappings.values().containsAll(outgoings)) {
            return mappings;
        }
        for (int i = 0; i < outgoings.size(); ++i) {
            mappings.put(enumConstants[i], (String)outgoings.get(i));
        }
        return mappings;
    }

    private void processMethodConsumingAPublisherOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Flow.Publisher result = (Flow.Publisher)this.invoke(multi);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return MultiUtils.publisher(result);
        };
    }

    private <T> Flow.Publisher<T> convertToDesiredPublisherType(Multi<T> multi) {
        Class parameterType = (Class)this.configuration.getParameterDescriptor().getTypes().get(0);
        if (parameterType.equals(Multi.class)) {
            return multi;
        }
        Optional converter = Registry.lookup((Class)parameterType);
        Object argument = multi;
        if (converter.isPresent()) {
            argument = (Flow.Publisher)((ReactiveTypeConverter)converter.get()).fromFlowPublisher(multi);
        }
        return argument;
    }

    private <T> Publisher<T> convertToDesiredReactiveStreamPublisherType(Multi<T> multi) {
        Class parameterType = (Class)this.configuration.getParameterDescriptor().getTypes().get(0);
        Optional converter = Registry.lookup((Class)parameterType);
        Publisher argument = AdaptersToReactiveStreams.publisher(multi);
        if (converter.isPresent()) {
            argument = (Publisher)((ReactiveTypeConverter)converter.get()).fromFlowPublisher(multi);
        }
        return argument;
    }

    private void processMethodConsumingAPublisherBuilderOfPayload() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            PublisherBuilder argument = ReactiveStreams.fromPublisher((Publisher)AdaptersToReactiveStreams.publisher((Flow.Publisher)multi));
            PublisherBuilder result = (PublisherBuilder)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)result.buildRs())).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodConsumingAReactiveStreamsPublisherOfPayload() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            Publisher argument = this.convertToDesiredReactiveStreamPublisherType(multi);
            Publisher result = (Publisher)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return Multi.createFrom().publisher(AdaptersToFlow.publisher((Publisher)result)).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodConsumingAPublisherOfPayloadAndProducingSplitMulti() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            MultiSplitter result = this.fillSplitFunction((Flow.Publisher<?>)multi);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return upstream;
        };
    }

    private <K extends Enum<K>> MultiSplitter<?, K> fillSplitFunction(Flow.Publisher<?> argument) {
        MultiSplitter result = (MultiSplitter)this.invoke(argument);
        Map keyChannelMappings = this.findKeyOutgoingChannelMappings((Enum[])result.keyType().getEnumConstants());
        keyChannelMappings.forEach((key, outgoing) -> {
            Multi m = result.get(key).onItem().transform(this::payloadToMessage).onItem().transformToUni(u -> Uni.createFrom().item(u)).concatenate(true);
            this.outgoingPublisherMap.put((String)outgoing, (Multi<Message<?>>)m);
        });
        return result;
    }

    private void processMethodConsumingAPublisherOfPayload() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            Flow.Publisher argument = this.convertToDesiredPublisherType(multi);
            Flow.Publisher result = (Flow.Publisher)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return MultiUtils.publisher(result).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodConsumingAPublisherOfKeyValue() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Multi<KeyedMulti<?, ?>> groups = KeyMultiUtils.convertToKeyedMulti(multi, this.extractors(), this.configuration);
            return groups.flatMap(km -> {
                Flow.Publisher result = (Flow.Publisher)this.invoke(km);
                return Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            }).map(this::payloadToMessage);
        };
    }

    private void processMethodConsumingAPublisherOfKeyValueMessage() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Multi<KeyedMulti<?, Message<?>>> groups = KeyMultiUtils.convertToKeyedMultiMessage(multi, this.extractors(), this.configuration);
            return groups.flatMap(km -> {
                Flow.Publisher result = (Flow.Publisher)this.invoke(km);
                return Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            });
        };
    }
}

