/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import org.wildfly.clustering.server.offset.Value;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaDataValues;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;

public class MutableSessionAccessMetaData
implements SessionAccessMetaData {
    private final ImmutableSessionAccessMetaData metaData;
    private final Value<Duration> sinceCreation;
    private final Value<Duration> lastAccess;

    public MutableSessionAccessMetaData(ImmutableSessionAccessMetaData metaData, MutableSessionAccessMetaDataValues values) {
        this.metaData = metaData;
        this.sinceCreation = values.getSinceCreation();
        this.lastAccess = values.getLastAccess();
    }

    @Override
    public boolean isNew() {
        return this.metaData.isNew() && ((Duration)this.lastAccess.get()).isZero();
    }

    @Override
    public Duration getSinceCreationDuration() {
        return (Duration)this.sinceCreation.get();
    }

    @Override
    public Duration getLastAccessDuration() {
        return (Duration)this.lastAccess.get();
    }

    @Override
    public void setLastAccessDuration(Duration sinceCreation, Duration lastAccess) {
        this.sinceCreation.set((Object)sinceCreation);
        this.lastAccess.set((Object)lastAccess);
    }
}

