/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.commands;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.as.jdr.commands.JdrCommand;
import org.jboss.dmr.ModelNode;

public class CallAS7
extends JdrCommand {
    private String operation = "read-resource";
    private LinkedList<String> resource = new LinkedList();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String name;

    public CallAS7(String name) {
        this.name = name + ".json";
    }

    public CallAS7 operation(String operation) {
        this.operation = operation;
        return this;
    }

    public CallAS7 param(String key, String val) {
        this.parameters.put(key, val);
        return this;
    }

    public CallAS7 resource(String ... parts) {
        for (String part : parts) {
            this.resource.add(part);
        }
        return this;
    }

    @Override
    public void execute() throws Exception {
        ModelNode request = new ModelNode();
        request.get("operation").set(this.operation);
        assert (this.resource.size() % 2 == 0);
        while (!this.resource.isEmpty()) {
            request.get("address").add(this.resource.removeFirst(), this.resource.removeFirst());
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            request.get(entry.getKey()).set(entry.getValue());
        }
        if (this.env.getHostControllerName() != null) {
            request.get("host").set(this.env.getHostControllerName());
        }
        if (this.env.getServerName() != null) {
            request.get("server").set(this.env.getServerName());
        }
        this.env.getZip().add(this.env.getClient().execute(request).toJSONString(true), this.name);
    }
}

