/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.LockType;
import jakarta.ejb.TransactionManagementType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ConcurrencyAttachments;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.concurrent.EJBContextHandleFactory;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.session.NotBusinessMethodInterceptor;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

public abstract class SessionBeanComponentDescription
extends EJBComponentDescription {
    private boolean noInterfaceViewPresent;
    private ConcurrencyManagementType concurrencyManagementType;
    private final Map<String, LockType> beanLevelLockType = new HashMap<String, LockType>();
    private final Map<String, AccessTimeoutDetails> beanLevelAccessTimeout = new HashMap<String, AccessTimeoutDetails>();
    private final Map<MethodIdentifier, LockType> methodLockTypes = new HashMap<MethodIdentifier, LockType>();
    private final Map<MethodIdentifier, AccessTimeoutDetails> methodAccessTimeouts = new HashMap<MethodIdentifier, AccessTimeoutDetails>();
    private final Set<MethodIdentifier> asynchronousMethods = new HashSet<MethodIdentifier>();
    private final Set<String> asynchronousClasses = new HashSet<String>();
    private String mappedName;

    public SessionBeanComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, DeploymentUnit deploymentUnit, SessionBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnit, (EnterpriseBeanMetaData)descriptorData);
    }

    public void addLocalBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            this.assertNoRemoteView(viewClassName);
            this.registerView(viewClassName, MethodInterfaceType.Local);
        }
    }

    public void addLocalBusinessInterfaceViews(String ... classNames) {
        this.addLocalBusinessInterfaceViews(Arrays.asList(classNames));
    }

    public void addNoInterfaceView() {
        this.noInterfaceViewPresent = true;
        EJBViewDescription viewDescription = this.registerView(this.getEJBClassName(), MethodInterfaceType.Local);
        viewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if (Modifier.isPublic(method.getModifiers()) || !SessionBeanComponentDescription.this.isNotOverriden(method, componentConfiguration.getComponentClass(), index)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new NotBusinessMethodInterceptor(method)), 272);
                }
            }
        });
    }

    public EJBViewDescription addWebserviceEndpointView() {
        return this.registerView(this.getEJBClassName(), MethodInterfaceType.ServiceEndpoint);
    }

    public void addRemoteBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            this.assertNoLocalView(viewClassName);
            this.registerView(viewClassName, MethodInterfaceType.Remote);
        }
    }

    private void assertNoRemoteView(String viewClassName) {
        EJBViewDescription ejbView = null;
        for (ViewDescription view : this.getViews()) {
            ejbView = (EJBViewDescription)view;
            if (!viewClassName.equals(ejbView.getViewClassName()) || ejbView.getMethodIntf() != MethodInterfaceType.Remote) continue;
            throw EjbLogger.ROOT_LOGGER.failToAddClassToLocalView(viewClassName, this.getEJBName());
        }
    }

    private void assertNoLocalView(String viewClassName) {
        EJBViewDescription ejbView = null;
        for (ViewDescription view : this.getViews()) {
            ejbView = (EJBViewDescription)view;
            if (!viewClassName.equals(ejbView.getViewClassName()) || ejbView.getMethodIntf() != MethodInterfaceType.Local) continue;
            throw EjbLogger.ROOT_LOGGER.failToAddClassToLocalView(viewClassName, this.getEJBName());
        }
    }

    public boolean hasNoInterfaceView() {
        return this.noInterfaceViewPresent;
    }

    public void setBeanLevelLockType(String className, LockType locktype) {
        this.beanLevelLockType.put(className, locktype);
    }

    public Map<String, LockType> getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public void setLockType(LockType lockType, MethodIdentifier method) {
        this.methodLockTypes.put(method, lockType);
    }

    public Map<MethodIdentifier, LockType> getMethodApplicableLockTypes() {
        return this.methodLockTypes;
    }

    public Map<String, AccessTimeoutDetails> getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public void setBeanLevelAccessTimeout(String className, AccessTimeoutDetails accessTimeout) {
        this.beanLevelAccessTimeout.put(className, accessTimeout);
    }

    public void setAccessTimeout(AccessTimeoutDetails accessTimeout, MethodIdentifier method) {
        this.methodAccessTimeouts.put(method, accessTimeout);
    }

    public Map<MethodIdentifier, AccessTimeoutDetails> getMethodApplicableAccessTimeouts() {
        return this.methodAccessTimeouts;
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void setConcurrencyManagementType(ConcurrencyManagementType concurrencyManagementType) {
        this.concurrencyManagementType = concurrencyManagementType;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void addAsynchronousMethod(MethodIdentifier methodIdentifier) {
        this.asynchronousMethods.add(methodIdentifier);
    }

    public Set<MethodIdentifier> getAsynchronousMethods() {
        return this.asynchronousMethods;
    }

    public void addAsynchronousClass(String viewName) {
        this.asynchronousClasses.add(viewName);
    }

    public Set<String> getAsynchronousClasses() {
        return this.asynchronousClasses;
    }

    public abstract SessionBeanType getSessionBeanType();

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        super.setupViewInterceptors(view);
        SessionBeanComponentDescription.addTxManagementInterceptorForView(view);
        if (view.isEjb2xView()) {
            view.getConfigurators().add(this.getSessionBeanObjectViewConfigurator());
        }
    }

    protected abstract ViewConfigurator getSessionBeanObjectViewConfigurator();

    protected static void addTxManagementInterceptorForView(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
                if (TransactionManagementType.CONTAINER.equals((Object)ejbComponentDescription.getTransactionManagementType())) {
                    configuration.addViewInterceptor(CMTTxInterceptor.FACTORY, 1280);
                }
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                Map additionalComponentFactories;
                ArrayList<EJBContextHandleFactory> list;
                configuration.addPostConstructInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                configuration.addPreDestroyInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                if (description.isPassivationApplicable()) {
                    configuration.addPrePassivateInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                    configuration.addPostActivateInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                }
                if ((list = (ArrayList<EJBContextHandleFactory>)(additionalComponentFactories = (Map)context.getDeploymentUnit().getAttachment(ConcurrencyAttachments.ADDITIONAL_COMPONENT_FACTORIES)).get(configuration)) == null) {
                    list = new ArrayList<EJBContextHandleFactory>();
                    additionalComponentFactories.put(configuration, list);
                }
                list.add(EJBContextHandleFactory.INSTANCE);
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor(CurrentInvocationContextInterceptor.FACTORY, 1024);
            }
        });
    }

    @Override
    public boolean isSession() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return this.getSessionBeanType() == SessionBeanType.SINGLETON;
    }

    @Override
    public boolean isStateful() {
        return this.getSessionBeanType() == SessionBeanType.STATEFUL;
    }

    @Override
    public boolean isStateless() {
        return this.getSessionBeanType() == SessionBeanType.STATELESS;
    }

    public SessionBeanMetaData getDescriptorData() {
        return (SessionBeanMetaData)super.getDescriptorData();
    }

    private boolean isNotOverriden(Method method, Class<?> actualClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        return Modifier.isPrivate(method.getModifiers()) || ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, actualClass, (Method)method).getDeclaringClass() == method.getDeclaringClass();
    }

    public static enum SessionBeanType {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

