/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class ViewInterfaces {
    ViewInterfaces() {
    }

    static Set<Class<?>> getPotentialViewInterfaces(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            return Collections.emptySet();
        }
        HashSet potentialBusinessInterfaces = new HashSet();
        for (Class<?> klass : interfaces) {
            if (klass.equals(Serializable.class) || klass.equals(Externalizable.class) || klass.getName().startsWith("jakarta.ejb.") || klass.getName().startsWith("groovy.lang.")) continue;
            potentialBusinessInterfaces.add(klass);
        }
        return potentialBusinessInterfaces;
    }

    static Set<DotName> getPotentialViewInterfaces(ClassInfo beanClass) {
        List interfaces = beanClass.interfaceNames();
        if (interfaces.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DotName> names = new HashSet<DotName>();
        for (DotName dotName : interfaces) {
            String name = dotName.toString();
            if (name.equals(Serializable.class.getName()) || name.equals(Externalizable.class.getName()) || name.startsWith("jakarta.ejb.") || name.startsWith("groovy.lang.")) continue;
            names.add(dotName);
        }
        return names;
    }
}

