/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.Dependency;

public interface ServiceDependency<V>
extends Dependency<ServiceBuilder<?>, V> {
    @Override
    default public ServiceDependency<V> andThen(final Consumer<? super ServiceBuilder<?>> after) {
        Objects.requireNonNull(after);
        return new ServiceDependency<V>(){

            @Override
            public void accept(ServiceBuilder<?> builder) {
                ServiceDependency.this.accept(builder);
                after.accept(builder);
            }

            @Override
            public V get() {
                return ServiceDependency.this.get();
            }
        };
    }

    default public <R> ServiceDependency<R> map(final Function<V, R> mapper) {
        Objects.requireNonNull(mapper);
        return new ServiceDependency<R>(){

            @Override
            public void accept(ServiceBuilder<?> builder) {
                ServiceDependency.this.accept(builder);
            }

            @Override
            public R get() {
                return mapper.apply(ServiceDependency.this.get());
            }
        };
    }

    default public <T, R> ServiceDependency<R> combine(final Dependency<ServiceBuilder<?>, T> dependency, final BiFunction<V, T, R> mapper) {
        Objects.requireNonNull(dependency);
        Objects.requireNonNull(mapper);
        return new ServiceDependency<R>(){

            @Override
            public void accept(ServiceBuilder<?> builder) {
                ServiceDependency.this.accept(builder);
                dependency.accept(builder);
            }

            @Override
            public R get() {
                return mapper.apply(ServiceDependency.this.get(), dependency.get());
            }
        };
    }

    public static <V> ServiceDependency<V> empty() {
        return SimpleServiceDependency.EMPTY;
    }

    public static <V> ServiceDependency<V> of(V value) {
        return value != null ? new SimpleServiceDependency<V>(value) : ServiceDependency.empty();
    }

    public static <V> ServiceDependency<V> from(Supplier<V> supplier) {
        Objects.requireNonNull(supplier);
        return new SuppliedServiceDependency<V>(supplier);
    }

    public static <V> ServiceDependency<V> on(ServiceName name) {
        return name != null ? new DefaultServiceDependency(name) : ServiceDependency.empty();
    }

    public static class DefaultServiceDependency<V>
    extends Dependency.DefaultDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        DefaultServiceDependency(ServiceName name) {
            super(name);
        }
    }

    public static class SuppliedServiceDependency<V>
    extends Dependency.SuppliedDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        SuppliedServiceDependency(Supplier<V> supplier) {
            super(supplier);
        }
    }

    public static class SimpleServiceDependency<V>
    extends Dependency.SimpleDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        static final ServiceDependency<Object> EMPTY = new SimpleServiceDependency<Object>(null);

        SimpleServiceDependency(V value) {
            super(value);
        }
    }
}

