/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.dynamic.ssl.DynamicSSLContext;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextImpl;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSPI;

class DynamicSSLContextHelper {
    DynamicSSLContextHelper() {
    }

    static SSLContext getDynamicSSLContextInstance(AuthenticationContext authenticationContext) {
        try {
            return new DynamicSSLContext((DynamicSSLContextSPI)new DynamicSSLContextImpl(authenticationContext));
        }
        catch (GeneralSecurityException | DynamicSSLContextException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainDynamicSSLContext();
        }
    }
}

