/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts;

import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.utils.Helper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;

public class PseudoControlWrapper {
    private ControlImple _local;
    private Control _control;
    private Coordinator _coordinator = null;
    private Uid _uid;
    private int _hashCode;

    public PseudoControlWrapper(Control control) {
        this._control = control;
        this._uid = null;
        this._local = null;
        this._hashCode = this.computeHashCode();
    }

    public PseudoControlWrapper(ControlImple controlImple) {
        this._control = null;
        this._uid = null;
        this._local = controlImple;
        this._hashCode = this.computeHashCode();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof ControlWrapper) {
            ControlWrapper wrapper = (ControlWrapper)o;
            if (this._local != null) {
                return this._local.get_uid().equals(wrapper.get_uid());
            }
            if (this._control == null) {
                return false;
            }
            if (wrapper.isLocal()) {
                try {
                    if (this._uid == null) {
                        this._uid = this.computeUid();
                    }
                    return this._uid.equals(wrapper.get_uid());
                }
                catch (Exception e) {
                    return false;
                }
            }
            try {
                if (this._coordinator == null) {
                    this._coordinator = this.computeCoordinator();
                }
                return this._coordinator.is_same_transaction(wrapper.get_coordinator());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private Coordinator computeCoordinator() throws Exception {
        return this._control.get_coordinator();
    }

    private Uid computeUid() throws Exception {
        if (this._coordinator == null) {
            this._coordinator = this.computeCoordinator();
        }
        UidCoordinator uidCoord = Helper.getUidCoordinator(this._coordinator);
        return Helper.getUid(uidCoord);
    }

    private int computeHashCode() {
        try {
            if (this._local != null) {
                return this._local.getImplHandle().hash_transaction();
            }
            if (this._control != null) {
                Coordinator coord = this._control.get_coordinator();
                return coord.hash_transaction();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

