/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;

public interface CacheContainerGroup
extends Group<Address, CacheContainerGroupMember> {
    public CacheContainerGroupMemberFactory getGroupMemberFactory();

    default public CacheContainerGroup forCache(Cache<?, ?> cache) {
        final CacheContainerGroup group = this;
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? group : new CacheContainerGroup(){
            private final GroupMembership<CacheContainerGroupMember> membership;
            {
                this.membership = org.wildfly.clustering.server.group.GroupMembership.singleton((GroupMember)((CacheContainerGroupMember)group.getLocalMember()));
            }

            public String getName() {
                return group.getName();
            }

            public CacheContainerGroupMember getLocalMember() {
                return (CacheContainerGroupMember)group.getLocalMember();
            }

            public GroupMembership<CacheContainerGroupMember> getMembership() {
                return this.membership;
            }

            public boolean isSingleton() {
                return true;
            }

            public Registration register(GroupMembershipListener<CacheContainerGroupMember> object) {
                return Registration.EMPTY;
            }

            @Override
            public CacheContainerGroupMemberFactory getGroupMemberFactory() {
                return group.getGroupMemberFactory();
            }
        };
    }
}

