/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.moduleservice.ModuleLoadService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class DeploymentListModulesHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "list-modules";

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final PathAddress currentAddress = context.getCurrentAddress();
        final boolean subDeploymentFlag = currentAddress.getLastElement().getKey().equals("subdeployment");
        PathAddress address = subDeploymentFlag ? currentAddress.getParent() : currentAddress;
        ModelNode model = context.readResourceFromRoot(address, false).getModel();
        final boolean verbose = DeploymentAttributes.VERBOSE.resolveModelAttribute(context, operation).asBoolean();
        boolean enabled = DeploymentAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
        final String runtimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, model).asString();
        final String item = context.getCurrentAddressValue();
        if (enabled && context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceRegistry sr = context.getServiceRegistry(false);
                    ServiceController deploymentUnitSc = sr.getService(Services.deploymentUnitName(runtimeName));
                    DeploymentUnit deploymentUnit = (DeploymentUnit)deploymentUnitSc.getValue();
                    ModuleIdentifier moduleIdentifier = null;
                    if (subDeploymentFlag) {
                        for (DeploymentUnit subDeployment : deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
                            if (!subDeployment.getName().equals(item)) continue;
                            moduleIdentifier = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
                            break;
                        }
                        if (moduleIdentifier == null) {
                            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(currentAddress);
                        }
                    } else {
                        moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
                    }
                    ServiceController moduleLoadServiceController = sr.getService(ServiceModuleLoader.moduleServiceName(moduleIdentifier.toString()));
                    ModuleLoadService moduleLoadService = (ModuleLoadService)moduleLoadServiceController.getService();
                    ModelNode result = new ModelNode();
                    List<ModuleDependency> dependencies = moduleLoadService.getSystemDependencies();
                    Collections.sort(dependencies, Comparator.comparing(ModuleDependency::getDependencyModule));
                    result.get("system-dependencies").set(DeploymentListModulesHandler.this.buildDependenciesInfo(dependencies, verbose));
                    dependencies = moduleLoadService.getLocalDependencies();
                    Collections.sort(dependencies, Comparator.comparing(ModuleDependency::getDependencyModule));
                    result.get("local-dependencies").set(DeploymentListModulesHandler.this.buildDependenciesInfo(dependencies, verbose));
                    dependencies = moduleLoadService.getUserDependencies();
                    Collections.sort(dependencies, Comparator.comparing(ModuleDependency::getDependencyModule));
                    result.get("user-dependencies").set(DeploymentListModulesHandler.this.buildDependenciesInfo(dependencies, verbose));
                    context.getResult().set(result);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private ModelNode buildDependenciesInfo(List<ModuleDependency> dependencies, boolean verbose) {
        ModelNode deps = new ModelNode().setEmptyList();
        for (ModuleDependency dependency : dependencies) {
            ModelNode depData = new ModelNode();
            depData.get("name").set(dependency.getDependencyModule());
            if (verbose) {
                depData.get("optional").set(dependency.isOptional());
                depData.get("export").set(dependency.isExport());
                depData.get("import-services").set(dependency.isImportServices());
            }
            deps.add(depData);
        }
        return deps;
    }
}

