/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.parser;

import com.sun.xml.xsom.impl.parser.Messages;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class XmlFactory {
    private static final Logger LOGGER = Logger.getLogger(XmlFactory.class.getName());
    private static final String DISABLE_XML_SECURITY = "org.glassfish.jaxb.disableXmlSecurity";
    private static final boolean XML_SECURITY_DISABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(XmlFactory.DISABLE_XML_SECURITY);
        }
    });

    private XmlFactory() {
    }

    private static boolean isXMLSecurityDisabled(boolean runtimeSetting) {
        return XML_SECURITY_DISABLED || runtimeSetting;
    }

    public static SAXParserFactory createParserFactory(boolean disableSecureProcessing) throws IllegalStateException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SAXParserFactory instance: {0}", factory);
            }
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XmlFactory.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
        catch (AbstractMethodError er) {
            LOGGER.log(Level.SEVERE, null, er);
            throw new IllegalStateException(Messages.format("INVALID_JAXP_IMPLEMENTATION", new Object[0]), er);
        }
    }
}

