/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.Objects;
import java.util.function.Function;

public interface Predicate<T>
extends java.util.function.Predicate<T> {
    public static final Predicate<?> ALWAYS = new SimplePredicate(true);
    public static final Predicate<?> NEVER = new SimplePredicate(false);

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    public static <T> Predicate<T> isEqual(T object) {
        return object == null ? Objects::isNull : object::equals;
    }

    public static <T> Predicate<T> same(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return object == value;
            }
        };
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return predicate.negate();
    }

    default public <V> Predicate<V> map(final Function<V, T> mapper) {
        return new Predicate<V>(){

            @Override
            public boolean test(V test) {
                return Predicate.this.test(mapper.apply(test));
            }
        };
    }

    @Override
    default public Predicate<T> and(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return Predicate.this.test(test) && other.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> negate() {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return !Predicate.this.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> or(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return Predicate.this.test(test) || other.test(test);
            }
        };
    }

    public static class SimplePredicate<T>
    implements Predicate<T> {
        private final boolean value;

        SimplePredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(T value) {
            return this.value;
        }
    }
}

