/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.mechanism;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRJWT", length=5)
interface MechanismLogging
extends BasicLogger {
    public static final MechanismLogging log = (MechanismLogging)Logger.getMessageLogger(MechanismLogging.class, (String)MechanismLogging.class.getPackage().getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11000, value="Success")
    public void success();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11001, value="Unable to validate bearer token")
    public void unableToValidateBearerToken(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11002, value="No usable bearer token was found in the request, continuing unauthenticated")
    public void noUsableBearerTokenFound();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11003, value="Failed to resolve the key. Either corrupt or unavailable.")
    public void noUsableKey();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11004, value="JWK set does not contain provided token 'kid'")
    public void kidNotInJWkSet();
}

