/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.SessionCacheKeyFilter;

public class InfinispanSessionManager<C, MV, AV, SC>
extends AbstractSessionManager<C, MV, AV, SC> {
    private final Supplier<SessionManager<SC>> manager;
    private final Supplier<Batch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final IdentifierFactory<String> identifierFactory;
    private final Scheduler<String, ExpirationMetaData> expirationScheduler;
    private final Runnable startTask;
    private final Registrar<SessionManager<SC>> registrar;
    private final AtomicReference<Registration> registration = new AtomicReference();

    public InfinispanSessionManager(Supplier<SessionManager<SC>> manager, SessionManagerConfiguration<C> configuration, final InfinispanSessionManagerConfiguration<SC> infinispanConfiguration, SessionFactory<C, MV, AV, SC> factory) {
        super(manager, configuration, infinispanConfiguration, factory, (Consumer)new Consumer<ImmutableSession>(){

            @Override
            public void accept(ImmutableSession session) {
                if (session.isValid() && !session.getMetaData().isImmortal()) {
                    infinispanConfiguration.getExpirationScheduler().schedule((Object)session.getId(), (Object)session.getMetaData());
                }
            }
        });
        this.manager = manager;
        this.cache = infinispanConfiguration.getCache();
        this.properties = infinispanConfiguration.getCacheProperties();
        this.identifierFactory = infinispanConfiguration.getIdentifierFactory();
        this.batcher = infinispanConfiguration.getBatchFactory();
        this.expirationScheduler = infinispanConfiguration.getExpirationScheduler();
        this.registrar = infinispanConfiguration.getRegistrar();
        this.startTask = infinispanConfiguration.getStartTask();
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        this.registration.set(this.registrar.register(this.manager.get()));
        this.identifierFactory.start();
        this.startTask.run();
    }

    public void stop() {
        try (Registration registration = this.registration.getAndSet(null);){
            PersistenceConfiguration persistence;
            if (!this.properties.isPersistent() && (persistence = this.cache.getCacheConfiguration().persistence()).passivation() && !persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
                try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet().stream();){
                    stream.filter(SessionCacheKeyFilter.META_DATA).forEach(arg_0 -> this.cache.evict(arg_0));
                }
            }
            this.identifierFactory.stop();
        }
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batcher;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public CompletionStage<Session<SC>> findSessionAsync(String id) {
        this.expirationScheduler.cancel((Object)id);
        return super.findSessionAsync(id);
    }

    public SessionStatistics getStatistics() {
        return this;
    }

    public Set<String> getActiveSessions() {
        return this.getLocalSessions((Cache<Key<String>, ?>)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD));
    }

    public Set<String> getSessions() {
        return this.getLocalSessions(this.cache);
    }

    private Set<String> getLocalSessions(Cache<Key<String>, ?> cache) {
        CacheStreamFilter filter = CacheStreamFilter.local(cache);
        try (Stream keys = (Stream)filter.apply((Object)cache.keySet().stream());){
            Set<String> set = keys.filter(SessionCacheKeyFilter.META_DATA).map(Key::getId).collect(Collectors.toSet());
            return set;
        }
    }
}

