/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.cache.DetachedSession;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class SessionAttributeActivationNotifierFactory<S, C, L, SC>
implements Function<String, SessionAttributeActivationNotifier>,
Registrar<Map.Entry<C, SessionManager<SC>>> {
    private final Map<C, SessionManager<SC>> contexts = new ConcurrentHashMap<C, SessionManager<SC>>();
    private final SessionSpecificationProvider<S, C> sessionProvider;
    private final SessionEventListenerSpecificationProvider<S, L> listenerProvider;
    private final Function<L, Consumer<S>> prePassivateFactory;
    private final Function<L, Consumer<S>> postActivateFactory;

    public SessionAttributeActivationNotifierFactory(SessionSpecificationProvider<S, C> sessionProvider, SessionEventListenerSpecificationProvider<S, L> listenerProvider) {
        this.sessionProvider = sessionProvider;
        this.listenerProvider = listenerProvider;
        this.prePassivateFactory = arg_0 -> listenerProvider.preEvent(arg_0);
        this.postActivateFactory = arg_0 -> listenerProvider.postEvent(arg_0);
    }

    public Registration register(Map.Entry<C, SessionManager<SC>> entry) {
        C context = entry.getKey();
        this.contexts.put(context, entry.getValue());
        return () -> this.contexts.remove(context);
    }

    @Override
    public SessionAttributeActivationNotifier apply(final String sessionId) {
        final Map<C, SessionManager<SC>> contexts = this.contexts;
        final SessionSpecificationProvider<S, C> sessionProvider = this.sessionProvider;
        final SessionEventListenerSpecificationProvider<S, L> listenerProvider = this.listenerProvider;
        final Function<L, Consumer<S>> prePassivateNotifier = this.prePassivateFactory;
        final Function<L, Consumer<S>> postActivateNotifier = this.postActivateFactory;
        return new SessionAttributeActivationNotifier(){

            public void prePassivate(Object value) {
                this.notify(prePassivateNotifier, value);
            }

            public void postActivate(Object value) {
                this.notify(postActivateNotifier, value);
            }

            public void notify(Function<L, Consumer<S>> notifier, Object value) {
                listenerProvider.asEventListener(value).ifPresent(listener -> {
                    for (Map.Entry entry : contexts.entrySet()) {
                        Object context = entry.getKey();
                        SessionManager manager = (SessionManager)entry.getValue();
                        DetachedSession session = new DetachedSession(manager, sessionId, null);
                        ((Consumer)notifier.apply(listener)).accept(sessionProvider.asSession((ImmutableSession)session, context));
                    }
                });
            }

            public void close() {
            }
        };
    }
}

