/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.MirrorAddressFilter;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPMirrorControllerSource
extends BasicMirrorController<Sender>
implements MirrorController,
ActiveMQComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Symbol EVENT_TYPE = Symbol.getSymbol((String)"x-opt-amq-mr-ev-type");
    public static final Symbol ACK_REASON = Symbol.getSymbol((String)"x-opt-amq-mr-ack-reason");
    public static final Symbol ADDRESS = Symbol.getSymbol((String)"x-opt-amq-mr-adr");
    public static final Symbol QUEUE = Symbol.getSymbol((String)"x-opt-amq-mr-qu");
    public static final Symbol BROKER_ID = Symbol.getSymbol((String)"x-opt-amq-bkr-id");
    public static final SimpleString BROKER_ID_SIMPLE_STRING = SimpleString.of((String)BROKER_ID.toString());
    public static final Symbol ADD_ADDRESS = Symbol.getSymbol((String)"addAddress");
    public static final Symbol DELETE_ADDRESS = Symbol.getSymbol((String)"deleteAddress");
    public static final Symbol CREATE_QUEUE = Symbol.getSymbol((String)"createQueue");
    public static final Symbol DELETE_QUEUE = Symbol.getSymbol((String)"deleteQueue");
    public static final Symbol POST_ACK = Symbol.getSymbol((String)"postAck");
    public static final Symbol INTERNAL_ID = Symbol.getSymbol((String)"x-opt-amq-mr-id");
    public static final Symbol INTERNAL_DESTINATION = Symbol.getSymbol((String)"x-opt-amq-mr-dst");
    public static final Symbol TARGET_QUEUES = Symbol.getSymbol((String)"x-opt-amq-mr-trg-q");
    public static final Symbol MIRROR_CAPABILITY = Symbol.getSymbol((String)"amq.mirror");
    public static final Symbol QPID_DISPATCH_WAYPOINT_CAPABILITY = Symbol.valueOf((String)"qd.waypoint");
    public static final SimpleString INTERNAL_ID_EXTRA_PROPERTY = SimpleString.of((String)INTERNAL_ID.toString());
    public static final SimpleString INTERNAL_BROKER_ID_EXTRA_PROPERTY = SimpleString.of((String)BROKER_ID.toString());
    private static final ThreadLocal<RoutingContext> mirrorControlRouting = ThreadLocal.withInitial(() -> new RoutingContextImpl(null));
    final Queue snfQueue;
    final ActiveMQServer server;
    final ReferenceIDSupplier idSupplier;
    final boolean acks;
    final boolean addQueues;
    final boolean deleteQueues;
    final MirrorAddressFilter addressFilter;
    private final AMQPBrokerConnection brokerConnection;
    private final boolean sync;
    private final PagedRouteContext pagedRouteContext;
    final AMQPMirrorBrokerConnectionElement replicaConfig;
    boolean started;
    TransactionOperation deliveryAsyncTX = new TransactionOperation(){

        public void beforePrepare(Transaction tx) throws Exception {
        }

        public void afterPrepare(Transaction tx) {
        }

        public void beforeCommit(Transaction tx) throws Exception {
        }

        public void afterCommit(Transaction tx) {
            AMQPMirrorControllerSource.this.snfQueue.deliverAsync();
        }

        public void beforeRollback(Transaction tx) throws Exception {
        }

        public void afterRollback(Transaction tx) {
        }

        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }

        public List<MessageReference> getListOnConsumer(long consumerID) {
            return null;
        }
    };

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return this.started;
    }

    public AMQPMirrorControllerSource(ReferenceIDSupplier referenceIdSupplier, Queue snfQueue, ActiveMQServer server, AMQPMirrorBrokerConnectionElement replicaConfig, AMQPBrokerConnection brokerConnection) {
        super(server);
        assert (snfQueue != null);
        this.replicaConfig = replicaConfig;
        this.snfQueue = snfQueue;
        if (!snfQueue.isInternalQueue()) {
            logger.debug("marking queue {} as internal to avoid redistribution kicking in", (Object)snfQueue.getName());
            snfQueue.setInternalQueue(true);
        }
        this.server = server;
        this.idSupplier = referenceIdSupplier;
        this.addQueues = replicaConfig.isQueueCreation();
        this.deleteQueues = replicaConfig.isQueueRemoval();
        this.addressFilter = new MirrorAddressFilter(replicaConfig.getAddressFilter());
        this.acks = replicaConfig.isMessageAcknowledgements();
        this.brokerConnection = brokerConnection;
        this.sync = replicaConfig.isSync();
        this.pagedRouteContext = new PagedRouteContext(snfQueue);
        if (this.sync) {
            logger.debug("Mirror is configured to sync, so pageStore={} being enforced to BLOCK, and not page", (Object)snfQueue.getName());
            snfQueue.getPagingStore().enforceAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        } else {
            logger.debug("Mirror is configured to not sync, so pageStore={} being enforced to PAGE", (Object)snfQueue.getName());
            snfQueue.getPagingStore().enforceAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        }
    }

    public Queue getSnfQueue() {
        return this.snfQueue;
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        logger.trace("{} addAddress {}", (Object)this.server, (Object)addressInfo);
        if (AMQPMirrorControllerTarget.getControllerInUse() != null && !addressInfo.isInternal()) {
            return;
        }
        if (addressInfo.isInternal()) {
            return;
        }
        if (addressInfo.isTemporary()) {
            return;
        }
        if (this.ignoreAddress(addressInfo.getName())) {
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, ADD_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.routeMirrorCommand(this.server, message);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        logger.trace("{} deleteAddress {}", (Object)this.server, (Object)addressInfo);
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || addressInfo.isInternal()) {
            return;
        }
        if (this.ignoreAddress(addressInfo.getName())) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, DELETE_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.routeMirrorCommand(this.server, message);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        logger.trace("{} createQueue {}", (Object)this.server, (Object)queueConfiguration);
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || queueConfiguration.isInternal().booleanValue()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Rejecting ping pong on create {} as isInternal={} and mirror target = {}", new Object[]{queueConfiguration, queueConfiguration.isInternal(), AMQPMirrorControllerTarget.getControllerInUse()});
            }
            return;
        }
        if (queueConfiguration.isTemporary().booleanValue()) {
            return;
        }
        if (this.ignoreAddress(queueConfiguration.getAddress())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skipping create {}, queue address {} doesn't match filter", (Object)queueConfiguration, (Object)queueConfiguration.getAddress());
            }
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(queueConfiguration.getAddress(), queueConfiguration.getName(), CREATE_QUEUE, null, queueConfiguration.toJSON());
            AMQPMirrorControllerSource.routeMirrorCommand(this.server, message);
        }
    }

    public void deleteQueue(SimpleString address, SimpleString queue) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("{} deleteQueue {}/{}", new Object[]{this.server, address, queue});
        }
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse())) {
            return;
        }
        if (this.ignoreAddress(address)) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(address, queue, DELETE_QUEUE, null, queue.toString());
            AMQPMirrorControllerSource.routeMirrorCommand(this.server, message);
        }
    }

    private boolean invalidTarget(MirrorController controller, Message message) {
        Object localRemoteID;
        if (controller == null) {
            return false;
        }
        String remoteID = this.getRemoteMirrorId();
        if (remoteID == null && (localRemoteID = message.getAnnotation(BROKER_ID_SIMPLE_STRING)) != null) {
            remoteID = String.valueOf(localRemoteID);
            logger.debug("Remote link is not initialized yet, setting remoteID from message as {}", (Object)remoteID);
        }
        return this.sameNode(remoteID, controller.getRemoteMirrorId());
    }

    private boolean invalidTarget(MirrorController controller) {
        return controller != null && this.sameNode(this.getRemoteMirrorId(), controller.getRemoteMirrorId());
    }

    private boolean ignoreAddress(SimpleString address) {
        if (address.startsWith(this.server.getConfiguration().getManagementAddress())) {
            return true;
        }
        return !this.addressFilter.match(address);
    }

    private boolean sameNode(String remoteID, String sourceID) {
        return remoteID != null && sourceID != null && remoteID.equals(sourceID);
    }

    Message copyMessageForPaging(Message message) {
        long newID = this.server.getStorageManager().generateID();
        long originalID = message.getMessageID();
        if (logger.isTraceEnabled()) {
            logger.trace("copying message {} as {}", (Object)originalID, (Object)newID);
        }
        message = message.copy(newID, false);
        message.setBrokerProperty(INTERNAL_ID_EXTRA_PROPERTY, (Object)originalID);
        return message;
    }

    public void sendMessage(Transaction tx, Message message, RoutingContext context) {
        SimpleString address = context.getAddress(message);
        if (context.isInternal()) {
            logger.trace("sendMessage::server {} is discarding send to avoid sending to internal queue", (Object)this.server);
            return;
        }
        if (this.invalidTarget(context.getMirrorSource(), message)) {
            logger.trace("sendMessage::server {} is discarding send to avoid infinite loop (reflection with the mirror)", (Object)this.server);
            return;
        }
        if (this.ignoreAddress(address)) {
            logger.trace("sendMessage::server {} is discarding send to address {}, address doesn't match filter", (Object)this.server, (Object)address);
            return;
        }
        try {
            context.setReusable(false);
            String nodeID = this.idSupplier.getServerID(message);
            String remoteID = this.getRemoteMirrorId();
            if (remoteID == null && AMQPMirrorControllerTarget.getControllerInUse() != null) {
                remoteID = AMQPMirrorControllerTarget.getControllerInUse().getRemoteMirrorId();
            }
            if (nodeID != null && nodeID.equals(remoteID)) {
                logger.trace("sendMessage::Message {} already belonged to the node, {}, it won't circle send", (Object)message, (Object)this.getRemoteMirrorId());
                return;
            }
            if (this.snfQueue.getPagingStore().page(message, tx, (RouteContextList)this.pagedRouteContext, this::copyMessageForPaging)) {
                if (tx == null) {
                    this.snfQueue.deliverAsync();
                } else if (tx.getProperty(13) == null) {
                    tx.putProperty(13, (Object)this.deliveryAsyncTX);
                    tx.addOperation(this.deliveryAsyncTX);
                }
                return;
            }
            if (message.isPaged()) {
                message = this.copyMessageForPaging(message);
            }
            final MessageReference ref = MessageReference.Factory.createReference((Message)message, (Queue)this.snfQueue);
            AMQPMirrorControllerSource.setProtocolData(ref, nodeID, this.idSupplier.getID(ref), context);
            this.snfQueue.refUp(ref);
            if (tx != null) {
                logger.debug("sendMessage::Mirroring Message {} with TX", (Object)message);
                this.getSendOperation(tx).addRef(ref);
            }
            if (this.sync) {
                OperationContext operContext = OperationContextImpl.getContext((ExecutorFactory)this.server.getExecutorFactory());
                if (tx == null) {
                    operContext.replicationLineUp();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("sendMessage::mirror syncUp context={}, ref={}", (Object)operContext, (Object)ref);
                }
                ref.setProtocolData(OperationContext.class, (Object)operContext);
            }
            if (message.isDurable() && this.snfQueue.isDurable()) {
                PostOfficeImpl.storeDurableReference((StorageManager)this.server.getStorageManager(), (Message)message, (Transaction)context.getTransaction(), (Queue)this.snfQueue, (boolean)true);
            }
            if (tx == null) {
                this.server.getStorageManager().afterStoreOperations(new IOCallback(){

                    public void done() {
                        PostOfficeImpl.processReference((MessageReference)ref, (boolean)false);
                    }

                    public void onError(int errorCode, String errorMessage) {
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        this.snfQueue.deliverAsync();
    }

    private void syncDone(MessageReference reference) {
        OperationContext ctx = (OperationContext)reference.getProtocolData(OperationContext.class);
        if (ctx != null) {
            ctx.replicationDone();
            logger.debug("syncDone::replicationDone::ctx={},ref={}", (Object)ctx, (Object)reference);
        } else {
            Message message = reference.getMessage();
            if (message != null) {
                ctx = (OperationContext)message.getUserContext(OperationContext.class);
                if (ctx != null) {
                    ctx.replicationDone();
                    logger.debug("syncDone::replicationDone message={}", (Object)message);
                } else {
                    logger.trace("syncDone::No operationContext set on message {}", (Object)message);
                }
            } else {
                logger.debug("syncDone::no message set on reference {}", (Object)reference);
            }
        }
    }

    public static void validateProtocolData(ReferenceIDSupplier referenceIDSupplier, MessageReference ref, SimpleString snfAddress) {
        if (ref.getProtocolData(DeliveryAnnotations.class) == null && !ref.getMessage().getAddressSimpleString().equals((Object)snfAddress)) {
            logger.trace("validating protocol data, adding protocol data for {}", (Object)ref);
            AMQPMirrorControllerSource.setProtocolData(referenceIDSupplier, ref);
        }
    }

    private static String setProtocolData(ReferenceIDSupplier referenceIDSupplier, MessageReference ref) {
        String brokerID = referenceIDSupplier.getServerID(ref);
        long id = referenceIDSupplier.getID(ref);
        AMQPMirrorControllerSource.setProtocolData(ref, brokerID, id, null);
        return brokerID;
    }

    private static void setProtocolData(MessageReference ref, String brokerID, long id, RoutingContext routingContext) {
        Properties amqpProperties;
        HashMap<Symbol, Object> daMap = new HashMap<Symbol, Object>();
        DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(daMap);
        if (brokerID != null) {
            daMap.put(BROKER_ID, brokerID);
        }
        daMap.put(INTERNAL_ID, id);
        String address = ref.getMessage().getAddress();
        if (!(address == null || (amqpProperties = AMQPMirrorControllerSource.getProperties(ref.getMessage())) != null && address.equals(amqpProperties.getTo()))) {
            daMap.put(INTERNAL_DESTINATION, ref.getMessage().getAddress());
        }
        if (routingContext != null && routingContext.isMirrorIndividualRoute()) {
            ArrayList queues = new ArrayList();
            routingContext.forEachDurable(q -> queues.add(String.valueOf(q.getName())));
            daMap.put(TARGET_QUEUES, queues);
        }
        ref.setProtocolData(DeliveryAnnotations.class, (Object)deliveryAnnotations);
    }

    private static Properties getProperties(Message message) {
        if (message instanceof AMQPMessage) {
            return AMQPMessageBrokerAccessor.getCurrentProperties((AMQPMessage)message);
        }
        return null;
    }

    private void postACKInternalMessage(MessageReference reference) {
        logger.debug("postACKInternalMessage::server={}, ref={}", (Object)this.server, (Object)reference);
        if (this.sync) {
            this.syncDone(reference);
        }
        if (reference != null && reference.getQueue() != null && reference.isPaged()) {
            reference.getQueue().deliverAsync();
        }
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        if (!this.acks || ref.getQueue().isMirrorController()) {
            this.postACKInternalMessage(ref);
            return;
        }
        this.snfQueue.deliverAsync();
    }

    public void preAcknowledge(Transaction tx, final MessageReference ref, AckReason reason) throws Exception {
        MirrorController controllerInUse;
        if (logger.isTraceEnabled()) {
            logger.trace("preAcknowledge::tx={}, ref={}, reason={}", new Object[]{tx, ref, reason});
        }
        if ((controllerInUse = AMQPMirrorControllerTarget.getControllerInUse()) != null && controllerInUse.isRetryACK()) {
            return;
        }
        if (!this.acks || ref.getQueue().isMirrorController()) {
            return;
        }
        if (this.invalidTarget(controllerInUse)) {
            return;
        }
        if (ref.getQueue() != null && (ref.getQueue().isInternalQueue() || ref.getQueue().isMirrorController())) {
            if (logger.isDebugEnabled()) {
                logger.debug("preAcknowledge::{} rejecting preAcknowledge queue={}, ref={} to avoid infinite loop with the mirror (reflection)", new Object[]{this.server, ref.getQueue().getName(), ref});
            }
            return;
        }
        if (this.ignoreAddress(ref.getQueue().getAddress())) {
            if (logger.isTraceEnabled()) {
                logger.trace("preAcknowledge::{} rejecting preAcknowledge queue={}, ref={}, queue address is excluded", new Object[]{this.server, ref.getQueue().getName(), ref});
            }
            return;
        }
        logger.trace("preAcknowledge::{} preAcknowledge {}", (Object)this.server, (Object)ref);
        String nodeID = this.idSupplier.getServerID(ref);
        long internalID = this.idSupplier.getID(ref);
        final Message messageCommand = this.createMessage(ref.getQueue().getAddress(), ref.getQueue().getName(), POST_ACK, nodeID, internalID, reason);
        if (this.sync) {
            OperationContext operationContext = OperationContextImpl.getContext((ExecutorFactory)this.server.getExecutorFactory());
            messageCommand.setUserContext(OperationContext.class, (Object)operationContext);
            if (tx == null) {
                operationContext.replicationLineUp();
            }
        }
        if (tx != null) {
            MirrorACKOperation operation = this.getAckOperation(tx);
            operation.addMessage(messageCommand, ref);
            AMQPMirrorControllerSource.routeMirrorCommand(this.server, messageCommand, tx);
        } else {
            this.server.getStorageManager().afterStoreOperations(new IOCallback(){

                public void done() {
                    try {
                        logger.debug("preAcknowledge::afterStoreOperation for messageReference {}", (Object)ref);
                        AMQPMirrorControllerSource.routeMirrorCommand(AMQPMirrorControllerSource.this.server, messageCommand);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    private MirrorACKOperation getAckOperation(Transaction tx) {
        MirrorACKOperation ackOperation = (MirrorACKOperation)tx.getProperty(11);
        if (ackOperation == null) {
            logger.trace("getAckOperation::setting operation on transaction {}", (Object)tx);
            ackOperation = new MirrorACKOperation(this.server);
            tx.putProperty(11, (Object)ackOperation);
            tx.afterWired((Runnable)ackOperation);
        }
        return ackOperation;
    }

    private MirrorSendOperation getSendOperation(Transaction tx) {
        if (tx == null) {
            return null;
        }
        MirrorSendOperation sendOperation = (MirrorSendOperation)((Object)tx.getProperty(12));
        if (sendOperation == null) {
            logger.trace("getSendOperation::setting operation on transaction {}", (Object)tx);
            sendOperation = new MirrorSendOperation();
            tx.putProperty(12, (Object)sendOperation);
            tx.afterStore((TransactionOperation)sendOperation);
        }
        return sendOperation;
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, String brokerID, Object body) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, brokerID, body, null);
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, String brokerID, Object body, AckReason ackReason) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, brokerID, body, ackReason);
    }

    public static void routeMirrorCommand(ActiveMQServer server, Message message) throws Exception {
        AMQPMirrorControllerSource.routeMirrorCommand(server, message, null);
    }

    public static void routeMirrorCommand(ActiveMQServer server, Message message, Transaction tx) throws Exception {
        message.setMessageID(server.getStorageManager().generateID());
        RoutingContext ctx = mirrorControlRouting.get();
        ctx.clear().setMirrorOption(RoutingContext.MirrorOption.disabled).setLoadBalancingType(MessageLoadBalancingType.LOCAL_ONLY).setTransaction(tx);
        logger.debug("SetTX {}", (Object)tx);
        server.getPostOffice().route(message, ctx, false);
    }

    static class PagedRouteContext
    implements RouteContextList {
        private final List<Queue> durableQueues;
        private final List<Queue> nonDurableQueues;

        PagedRouteContext(Queue snfQueue) {
            ArrayList<Queue> queues = new ArrayList<Queue>(1);
            queues.add(snfQueue);
            if (snfQueue.isDurable()) {
                this.durableQueues = queues;
                this.nonDurableQueues = Collections.emptyList();
            } else {
                this.durableQueues = Collections.emptyList();
                this.nonDurableQueues = queues;
            }
        }

        public int getNumberOfNonDurableQueues() {
            return this.nonDurableQueues.size();
        }

        public int getNumberOfDurableQueues() {
            return this.durableQueues.size();
        }

        public List<Queue> getDurableQueues() {
            return this.durableQueues;
        }

        public List<Queue> getNonDurableQueues() {
            return this.nonDurableQueues;
        }

        public void addAckedQueue(Queue queue) {
        }

        public boolean isAlreadyAcked(Queue queue) {
            return false;
        }
    }

    private static final class MirrorSendOperation
    extends TransactionOperationAbstract {
        final List<MessageReference> refs = new ArrayList<MessageReference>();

        private MirrorSendOperation() {
        }

        public void addRef(MessageReference ref) {
            this.refs.add(ref);
        }

        public void beforeCommit(Transaction tx) {
            this.refs.forEach(this::doBeforeCommit);
        }

        private void doBeforeCommit(MessageReference ref) {
            OperationContext context = (OperationContext)ref.getProtocolData(OperationContext.class);
            if (context != null) {
                context.replicationLineUp();
            }
        }

        public void afterRollback(Transaction tx) {
            logger.debug("MirrorSendOperation::afterRollback, refs:{}", this.refs);
            this.refs.forEach(this::doBeforeRollback);
        }

        private void doBeforeRollback(MessageReference ref) {
            OperationContext localCTX = (OperationContext)ref.getProtocolData(OperationContext.class);
            if (localCTX != null) {
                localCTX.replicationDone();
            }
        }

        public void afterCommit(Transaction tx) {
            logger.debug("MirrorSendOperation::afterCommit refs:{}", this.refs);
            this.refs.forEach(this::doAfterCommit);
        }

        private void doAfterCommit(MessageReference ref) {
            PostOfficeImpl.processReference((MessageReference)ref, (boolean)false);
        }
    }

    private static class MirrorACKOperation
    implements Runnable {
        final ActiveMQServer server;
        final HashMap<Message, MessageReference> acks = new HashMap();

        MirrorACKOperation(ActiveMQServer server) {
            this.server = server;
        }

        public void addMessage(Message message, MessageReference ref) {
            this.acks.put(message, ref);
        }

        @Override
        public void run() {
            logger.debug("MirrorACKOperation::wired processing {}", this.acks);
            this.acks.forEach(this::doWired);
        }

        private void doWired(Message ack, MessageReference ref) {
            OperationContext context = (OperationContext)ack.getUserContext(OperationContext.class);
            if (context != null) {
                context.replicationLineUp();
            }
        }
    }
}

