/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.ee.concurrent.WildFlyManagedExecutorService;
import org.jboss.as.ee.concurrent.service.ConcurrentServiceNames;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.Assert;

public class ManagedExecutorHungTasksPeriodicTerminationService
implements Service {
    private volatile ScheduledExecutorService scheduler;
    private Consumer<ManagedExecutorHungTasksPeriodicTerminationService> consumer;

    public void install(OperationContext context) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ConcurrentServiceNames.HUNG_TASK_PERIODIC_TERMINATION_SERVICE_NAME).setInstance((Service)this);
        this.consumer = serviceBuilder.provides(new ServiceName[]{ConcurrentServiceNames.HUNG_TASK_PERIODIC_TERMINATION_SERVICE_NAME});
        serviceBuilder.install();
    }

    public void start(StartContext startContext) throws StartException {
        this.consumer.accept(this);
    }

    public void stop(StopContext stopContext) {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        this.consumer.accept(null);
    }

    public synchronized Future startHungTaskPeriodicTermination(WildFlyManagedExecutorService executor, long hungTaskTerminationPeriod) {
        Assert.checkNotNullParamWithNullPointerException((String)"executor", (Object)executor);
        if (hungTaskTerminationPeriod <= 0L) {
            throw EeLogger.ROOT_LOGGER.hungTaskTerminationPeriodIsNotBiggerThanZero();
        }
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory());
        }
        return this.scheduler.scheduleAtFixedRate(() -> executor.terminateHungTasks(), hungTaskTerminationPeriod, hungTaskTerminationPeriod, TimeUnit.MILLISECONDS);
    }

    private static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private final java.util.concurrent.ThreadFactory threadFactory = Executors.defaultThreadFactory();

        private ThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.threadFactory.newThread(r);
            t.setName("managed-executor-hungtaskperiodictermination-" + t.getName());
            return t;
        }
    }
}

