/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.wildfly.clustering.context.ThreadContextReference;

public enum ContextClassLoaderReference implements ThreadContextReference<ClassLoader>
{
    INSTANCE;


    @Override
    public ClassLoader apply(final Thread thread) {
        if (System.getSecurityManager() == null) {
            return thread.getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return thread.getContextClassLoader();
            }
        });
    }

    @Override
    public void accept(final Thread thread, final ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            thread.setContextClassLoader(loader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(loader);
                    return null;
                }
            });
        }
    }
}

