/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.api;

import io.narayana.lra.Current;
import io.narayana.lra.logging.LRALogger;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@Provider
public class CoordinatorContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        Object lraContext;
        MultivaluedMap headers = requestContext.getHeaders();
        URI lraId = null;
        if (headers.containsKey((Object)"Long-Running-Action")) {
            try {
                lraId = new URI((String)Current.getLast((List)((List)headers.get((Object)"Long-Running-Action"))));
            }
            catch (URISyntaxException e) {
                String errMsg = String.format("header %s contains an invalid URL %s: %s", "Long-Running-Action", Current.getLast((List)((List)headers.get((Object)"Long-Running-Action"))), e.getMessage());
                LRALogger.logger.debugf(errMsg, new Object[0]);
                throw new WebApplicationException(errMsg, (Throwable)e, Response.status((int)Response.Status.PRECONDITION_FAILED.getStatusCode()).entity((Object)errMsg).build());
            }
        }
        if (!headers.containsKey((Object)"Long-Running-Action") && (lraContext = requestContext.getProperty("Long-Running-Action")) != null) {
            lraId = (URI)lraContext;
        }
        if (lraId != null) {
            Current.updateLRAContext(lraId, (MultivaluedMap)headers);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!responseContext.getHeaders().containsKey((Object)"Narayana-LRA-API-version")) {
            String responseVersion = requestContext.getHeaders().containsKey((Object)"Narayana-LRA-API-version") ? requestContext.getHeaderString("Narayana-LRA-API-version") : "1.2";
            responseContext.getHeaders().putSingle((Object)"Narayana-LRA-API-version", (Object)responseVersion);
        }
        Current.updateLRAContext((ContainerResponseContext)responseContext);
    }
}

