/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.api;

import io.narayana.lra.LRAData;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.logging.LRALogger;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

@Tag(name="LRA Recovery")
public class RecoveryCoordinator {
    private final LRAService lraService = LRARecoveryModule.getService();

    @GET
    @Path(value="{LRAId}/{RecCoordId}")
    @Produces(value={"application/json"})
    @Operation(summary="Lookup the participant URL", description="Performing a GET on the recovery URL (returned from a join request) will return the original participant URL(s)")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this participant"), @APIResponse(responseCode="200", description="The participant associated with this recovery id is returned", content={@Content(schema=@Schema(title="The original participant URI"))})})
    public String getCompensator(@Parameter(name="LRAId", description="Identifies the LRAId that the participant joined", required=true) @PathParam(value="LRAId") String lraId, @Parameter(name="RecCoordId", description="An identifier that was returned by the coordinator when a participant joined the LRA", required=true) @PathParam(value="RecCoordId") String rcvCoordId, @Context UriInfo uriInfo) throws NotFoundException {
        String context = uriInfo.getRequestUri().toASCIIString();
        String compensatorUrl = this.lraService.getParticipant(context);
        if (compensatorUrl == null) {
            String errorMsg = LRALogger.i18nLogger.warn_cannotFoundCompensatorUrl(rcvCoordId, lraId);
            LRALogger.logger.warn((Object)errorMsg);
            throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMsg).build());
        }
        return compensatorUrl;
    }

    @PUT
    @Path(value="{LRAId}/{RecCoordId}")
    @Produces(value={"application/json"})
    @Operation(summary="Update the endpoint that a participant is prepared to accept requests on.", description="Performing a PUT on the recovery URL will overwrite the old <participant URL> with the new one supplied and return the old url. The old value is returned.The full URL was returned when the participant first joined the LRA.")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this participant"), @APIResponse(responseCode="200", description="The coordinator has replaced the old participant with the new one")})
    public String replaceCompensator(@Parameter(name="LRAId", description="Identifies the LRAId that the participant joined", required=true) @PathParam(value="LRAId") String lraId, @Parameter(name="RecCoordId", description="An identifier that was returned by the coordinator when a participant joined the LRA", required=true) @PathParam(value="RecCoordId") String rcvCoordId, @Context UriInfo uriInfo, String newCompensatorUrl) throws NotFoundException {
        String context = uriInfo.getRequestUri().toASCIIString();
        String compensatorUrl = this.lraService.getParticipant(context);
        if (compensatorUrl != null) {
            URI lra;
            try {
                lra = new URI(lraId);
            }
            catch (URISyntaxException e) {
                LRALogger.i18nLogger.error_invalidFormatOfLraIdReplacingCompensatorURI(lraId, compensatorUrl, e);
                String errMsg = String.format("%s: %s", lraId, e.getMessage());
                throw new WebApplicationException(errMsg, (Throwable)e, Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)errMsg).build());
            }
            if (!this.lraService.updateRecoveryURI(lra, newCompensatorUrl, context, true)) {
                throw new ServiceUnavailableException(LRALogger.i18nLogger.warn_saveState("deactivate"));
            }
            return context;
        }
        String errorMsg = LRALogger.i18nLogger.warn_cannotFoundCompensatorUrl(rcvCoordId, lraId);
        LRALogger.logger.warn((Object)errorMsg);
        throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMsg).build());
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List recovering Long Running Actions", description="Returns LRAs that are recovering (ie some participants still need to be ran)")
    @APIResponse(responseCode="200", content={@Content(schema=@Schema(type=SchemaType.ARRAY, implementation=LRAData.class))})
    public List<LRAData> getRecoveringLRAs() {
        return this.lraService.getAllRecovering(true);
    }

    @GET
    @Path(value="failed")
    @Produces(value={"application/json"})
    @Operation(summary="List failed Long Running Actions", description="Returns LRAs that have failed.  Failure records are vital pieces of data needed to aid failure tracking and analysis  and are retained for inspection.")
    @APIResponse(responseCode="200", content={@Content(schema=@Schema(type=SchemaType.ARRAY, implementation=LRAData.class))})
    public List<LRAData> getFailedLRAs() {
        return this.lraService.getFailedLRAs();
    }

    @DELETE
    @Path(value="{LraId}")
    @Operation(summary="Remove the log for a failed LRA")
    @APIResponses(value={@APIResponse(responseCode="204", description="If the LRA log was successfully removed"), @APIResponse(responseCode="412", description="If the LRA is not in an end state (in which case the response entity will indicate the current state at the time of the request)"), @APIResponse(responseCode="412", description="If the input LRA does not correspond to a valid URI (in which case the response entity will contain the error message)"), @APIResponse(responseCode="500", description="If the attempt to remove the LRA log failed. This return code does not discriminate between a failure at the log storage level or if the log did not exist)")})
    public Response deleteFailedLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId) throws NotFoundException {
        try {
            URI lra = new URI(lraId);
            LRAData lraData = this.lraService.getLRA(lra);
            LRAStatus status = lraData.getStatus();
            if (status == LRAStatus.FailedToCancel || status == LRAStatus.FailedToClose) {
                return this.removeLog(lraId);
            }
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)lraData.getStatus().name()).build();
        }
        catch (NotFoundException e) {
            return this.removeLog(lraId);
        }
        catch (URISyntaxException e) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("%s#deleteLRA: %s: %s", (Object)this.getClass().getCanonicalName(), (Object)lraId, (Object)e.getMessage());
            }
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("%s: %s", lraId, e.getMessage())).build();
        }
    }

    private Response removeLog(String lra) {
        if (this.lraService.removeLog(lra)) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

