/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.processors;

import java.util.Set;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.vertx.processors.VertxDeploymentAttachment;

public class VertxDependenciesProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.DEPENDENCIES;
    public static final int PRIORITY = 16384;
    private static final String MODULE_VERTX_EXTENSION = "org.wildfly.extension.vertx";
    private static final String MODULE_VERTX_CORE = "io.vertx.core";
    private static final String MODULE_VERTX_MUTINY_CORE = "io.smallrye.reactive.mutiny.vertx-core";
    private static final String MODULE_MUTINY = "io.smallrye.reactive.mutiny";
    private static final String MODULE_SMALLRYE_COMMON_ANNOTATION = "io.smallrye.common.annotation";

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        if (!VertxDeploymentAttachment.isVertxDeployment(deploymentUnit)) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependencies(Set.of(new ModuleDependency(moduleLoader, MODULE_VERTX_EXTENSION, false, true, true, false), new ModuleDependency(moduleLoader, MODULE_VERTX_CORE, false, true, true, false), new ModuleDependency(moduleLoader, MODULE_VERTX_MUTINY_CORE, false, true, true, false), new ModuleDependency(moduleLoader, MODULE_MUTINY, false, true, true, false), new ModuleDependency(moduleLoader, MODULE_SMALLRYE_COMMON_ANNOTATION, true, false, false, false)));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

