/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurationContext;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTokenizerStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTypeStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerTypeStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerInstanceBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneNormalizerComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneNormalizerInstanceBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;

public class LuceneAnalysisConfigurationContextImpl
implements LuceneAnalysisConfigurationContext,
LuceneAnalysisDefinitionContributor {
    private final LuceneAnalysisComponentFactory factory;
    private Similarity similarity;
    private final Map<String, LuceneAnalyzerBuilder> analyzers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();
    private final Map<String, LuceneAnalyzerBuilder> normalizers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();

    public LuceneAnalysisConfigurationContextImpl(LuceneAnalysisComponentFactory factory) {
        this.factory = factory;
    }

    @Override
    public LuceneAnalyzerTypeStep analyzer(final String name) {
        return new LuceneAnalyzerTypeStep(){

            @Override
            public LuceneAnalyzerTokenizerStep custom() {
                LuceneAnalyzerComponentsStep definition = new LuceneAnalyzerComponentsStep(name);
                LuceneAnalysisConfigurationContextImpl.this.addAnalyzer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisConfigurationContext instance(Analyzer instance) {
                LuceneAnalyzerInstanceBuilder definition = new LuceneAnalyzerInstanceBuilder(instance);
                LuceneAnalysisConfigurationContextImpl.this.addAnalyzer(name, definition);
                return LuceneAnalysisConfigurationContextImpl.this;
            }
        };
    }

    @Override
    public LuceneNormalizerTypeStep normalizer(final String name) {
        return new LuceneNormalizerTypeStep(){

            @Override
            public LuceneNormalizerOptionalComponentsStep custom() {
                LuceneNormalizerComponentsStep definition = new LuceneNormalizerComponentsStep(name);
                LuceneAnalysisConfigurationContextImpl.this.addNormalizer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisConfigurationContext instance(Analyzer instance) {
                LuceneNormalizerInstanceBuilder definition = new LuceneNormalizerInstanceBuilder(name, instance);
                LuceneAnalysisConfigurationContextImpl.this.addNormalizer(name, definition);
                return LuceneAnalysisConfigurationContextImpl.this;
            }
        };
    }

    @Override
    public void similarity(Similarity similarity) {
        this.similarity = similarity;
    }

    @Override
    public Set<String> availableTokenizers() {
        return TokenizerFactory.availableTokenizers();
    }

    @Override
    public Set<String> availableCharFilters() {
        return CharFilterFactory.availableCharFilters();
    }

    @Override
    public Set<String> availableTokenFilters() {
        return TokenFilterFactory.availableTokenFilters();
    }

    @Override
    public void contribute(LuceneAnalysisDefinitionCollector collector) {
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.analyzers.entrySet()) {
            collector.collectAnalyzer(entry.getKey(), entry.getValue().build(this.factory));
        }
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.normalizers.entrySet()) {
            collector.collectNormalizer(entry.getKey(), entry.getValue().build(this.factory));
        }
    }

    @Override
    public Optional<Similarity> getSimilarity() {
        return Optional.ofNullable(this.similarity);
    }

    private void addAnalyzer(String name, LuceneAnalyzerBuilder definition) {
        this.analyzers.put(name, definition);
    }

    private void addNormalizer(String name, LuceneAnalyzerBuilder definition) {
        this.normalizers.putIfAbsent(name, definition);
    }
}

