/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class CountWork
implements ReadWork<Integer> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<?, ?> searcher;

    CountWork(LuceneSearcher<?, ?> searcher) {
        this.searcher = searcher;
    }

    @Override
    public Integer execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            return this.searcher.count(indexSearcher);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append("]");
        return sb.toString();
    }
}

