/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchStandardMatchPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> QUERY_ACCESSOR = JsonAccessor.root().property("query");
    private static final JsonObjectAccessor MATCH_ACCESSOR = JsonAccessor.root().property("match").asObject();
    private final JsonElement value;

    ElasticsearchStandardMatchPredicate(Builder<?> builder) {
        super(builder);
        this.value = builder.value;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY_ACCESSOR.set(innerObject, this.value);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        MATCH_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    static class Builder<F>
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements MatchPredicateBuilder {
        protected final ElasticsearchSearchIndexValueFieldContext<F> field;
        private final ElasticsearchFieldCodec<F> codec;
        private JsonElement value;

        Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.field = field;
            this.codec = codec;
        }

        public void fuzzy(int maxEditDistance, int exactPrefixLength) {
            throw log.fullTextFeaturesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }

        public void analyzer(String analyzerName) {
            throw log.fullTextFeaturesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }

        public void skipAnalysis() {
            throw log.fullTextFeaturesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }

        public void value(Object value, ValueModel valueModel) {
            this.value = this.field.encodingContext().convertAndEncode(this.scope, this.field, value, valueModel, ElasticsearchFieldCodec::encode);
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            throw log.fullTextFeaturesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            throw log.fullTextFeaturesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }

        public SearchPredicate build() {
            return new ElasticsearchStandardMatchPredicate(this);
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<MatchPredicateBuilder, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public MatchPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(this.codec, scope, field);
        }
    }
}

