/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.DynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.MetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.LockableMetadataIndexManager;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexManager;
import org.opensaml.saml.saml2.common.SAML2Support;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicMetadataResolver
extends AbstractMetadataResolver
implements DynamicMetadataResolver,
ClearableMetadataResolver {
    public static final String METRIC_TIMER_FETCH_FROM_ORIGIN_SOURCE = "timer.fetchFromOriginSource";
    public static final String METRIC_TIMER_RESOLVE = "timer.resolve";
    public static final String METRIC_RATIOGAUGE_FETCH_TO_RESOLVE = "ratioGauge.fetchToResolve";
    public static final String METRIC_GAUGE_NUM_LIVE_ENTITYIDS = "gauge.numLiveEntityIDs";
    public static final String METRIC_GAUGE_PERSISTENT_CACHE_INIT = "gauge.persistentCacheInitialization";
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataResolver.class);
    @NonnullAfterInit
    private String metricsBaseName;
    @Nullable
    private com.codahale.metrics.Timer timerResolve;
    @Nullable
    private com.codahale.metrics.Timer timerFetchFromOriginSource;
    @Nullable
    private RatioGauge ratioGaugeFetchToResolve;
    @Nullable
    private Gauge<Integer> gaugeNumLiveEntityIDs;
    @Nullable
    private Gauge<PersistentCacheInitializationMetrics> gaugePersistentCacheInit;
    @Nullable
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    @Nonnull
    private Duration minCacheDuration;
    @Nonnull
    private Duration maxCacheDuration;
    @Nonnull
    private Duration negativeLookupCacheDuration;
    @Positive
    private Float refreshDelayFactor;
    @Nonnull
    private Duration maxIdleEntityData;
    private boolean removeIdleEntityData;
    @Nonnull
    private Duration expirationWarningThreshold;
    @Nonnull
    private Duration cleanupTaskInterval;
    private BackingStoreCleanupSweeper cleanupTask;
    private XMLObjectLoadSaveManager<EntityDescriptor> persistentCacheManager;
    private Function<EntityDescriptor, String> persistentCacheKeyGenerator;
    private boolean initializeFromPersistentCacheInBackground;
    @Nonnull
    private Duration backgroundInitializationFromCacheDelay;
    private Predicate<EntityDescriptor> initializationFromCachePredicate;
    @NonnullAfterInit
    private PersistentCacheInitializationMetrics persistentCacheInitMetrics;
    private Set<MetadataIndex> indexes = Collections.emptySet();
    private boolean initializing;

    public AbstractDynamicMetadataResolver(@Nullable Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(TimerSupport.getTimerName((Object)((Object)this)), true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
        this.expirationWarningThreshold = Duration.ZERO;
        this.minCacheDuration = Duration.ofMinutes(10L);
        this.maxCacheDuration = Duration.ofHours(8L);
        this.refreshDelayFactor = Float.valueOf(0.75f);
        this.negativeLookupCacheDuration = Duration.ofMinutes(10L);
        this.cleanupTaskInterval = Duration.ofMinutes(30L);
        this.maxIdleEntityData = Duration.ofHours(8L);
        this.removeIdleEntityData = true;
        this.initializeFromPersistentCacheInBackground = true;
        this.backgroundInitializationFromCacheDelay = Duration.ofSeconds(2L);
    }

    public boolean isInitializeFromPersistentCacheInBackground() {
        return this.initializeFromPersistentCacheInBackground;
    }

    public void setInitializeFromPersistentCacheInBackground(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.initializeFromPersistentCacheInBackground = flag;
    }

    @Nonnull
    public Duration getBackgroundInitializationFromCacheDelay() {
        return this.backgroundInitializationFromCacheDelay;
    }

    public void setBackgroundInitializationFromCacheDelay(@Nonnull Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)delay, (String)"Delay cannot be null");
        Constraint.isFalse((boolean)delay.isNegative(), (String)"Delay cannot be negative");
        this.backgroundInitializationFromCacheDelay = delay;
    }

    @Nullable
    public XMLObjectLoadSaveManager<EntityDescriptor> getPersistentCacheManager() {
        return this.persistentCacheManager;
    }

    public void setPersistentCacheManager(@Nullable XMLObjectLoadSaveManager<EntityDescriptor> manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.persistentCacheManager = manager;
    }

    public boolean isPersistentCachingEnabled() {
        return this.getPersistentCacheManager() != null;
    }

    @NonnullAfterInit
    public Function<EntityDescriptor, String> getPersistentCacheKeyGenerator() {
        return this.persistentCacheKeyGenerator;
    }

    public void setPersistentCacheKeyGenerator(@Nullable Function<EntityDescriptor, String> generator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.persistentCacheKeyGenerator = generator;
    }

    @NonnullAfterInit
    public Predicate<EntityDescriptor> getInitializationFromCachePredicate() {
        return this.initializationFromCachePredicate;
    }

    public void setInitializationFromCachePredicate(@Nullable Predicate<EntityDescriptor> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.initializationFromCachePredicate = predicate;
    }

    @Nonnull
    public Duration getMinCacheDuration() {
        return this.minCacheDuration;
    }

    public void setMinCacheDuration(@Nonnull Duration duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.minCacheDuration = duration;
    }

    @Nonnull
    public Duration getMaxCacheDuration() {
        return this.maxCacheDuration;
    }

    public void setMaxCacheDuration(@Nonnull Duration duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.maxCacheDuration = duration;
    }

    @Nonnull
    public Duration getNegativeLookupCacheDuration() {
        return this.negativeLookupCacheDuration;
    }

    public void setNegativeLookupCacheDuration(@Nonnull Duration duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.negativeLookupCacheDuration = duration;
    }

    @Nonnull
    public Float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(@Nonnull Float factor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (factor.floatValue() <= 0.0f || factor.floatValue() >= 1.0f) {
            throw new IllegalArgumentException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    public boolean isRemoveIdleEntityData() {
        return this.removeIdleEntityData;
    }

    public void setRemoveIdleEntityData(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.removeIdleEntityData = flag;
    }

    @Nonnull
    public Duration getMaxIdleEntityData() {
        return this.maxIdleEntityData;
    }

    public void setMaxIdleEntityData(@Nonnull Duration max) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)max, (String)"Max idle time cannot be null");
        Constraint.isFalse((boolean)max.isNegative(), (String)"Max idle time cannot be negative");
        this.maxIdleEntityData = max;
    }

    @Nonnull
    public Duration getExpirationWarningThreshold() {
        return this.expirationWarningThreshold;
    }

    public void setExpirationWarningThreshold(@Nullable Duration threshold) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (threshold == null) {
            this.expirationWarningThreshold = Duration.ZERO;
        }
        if (threshold.isNegative()) {
            throw new IllegalArgumentException("Expiration warning threshold must be greater than or equal to 0");
        }
        this.expirationWarningThreshold = threshold;
    }

    @Nonnull
    public Duration getCleanupTaskInterval() {
        return this.cleanupTaskInterval;
    }

    public void setCleanupTaskInterval(@Nonnull Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)interval, (String)"Cleanup task interval may not be null");
        Constraint.isFalse((interval.isNegative() || interval.isZero() ? 1 : 0) != 0, (String)"Cleanup task interval must be positive");
        this.cleanupTaskInterval = interval;
    }

    @NonnullAfterInit
    public String getMetricsBaseName() {
        return this.metricsBaseName;
    }

    public void setMetricsBaseName(@Nullable String baseName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metricsBaseName = StringSupport.trimOrNull((String)baseName);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<MetadataIndex> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(@Nullable Set<MetadataIndex> newIndexes) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.indexes = newIndexes == null ? Collections.emptySet() : Set.copyOf(newIndexes);
    }

    protected boolean indexesEnabled() {
        return !this.getBackingStore().getSecondaryIndexManager().getIndexes().isEmpty();
    }

    public void clear() throws ResolverException {
        DynamicEntityBackingStore backingStore = this.getBackingStore();
        HashSet<String> entityIDs = new HashSet<String>();
        entityIDs.addAll(backingStore.getIndexedDescriptors().keySet());
        entityIDs.addAll(backingStore.getManagementDataEntityIDs());
        for (String entityID : entityIDs) {
            this.clear(entityID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(@Nonnull String entityID) throws ResolverException {
        DynamicEntityBackingStore backingStore = this.getBackingStore();
        EntityManagementData mgmtData = backingStore.getManagementData(entityID);
        Lock writeLock = mgmtData.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.removeByEntityID(entityID, backingStore);
            backingStore.removeManagementData(entityID);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Timer.Context contextResolve = MetricsSupport.startTimer((com.codahale.metrics.Timer)this.timerResolve);
        try {
            Iterable<EntityDescriptor> candidates = null;
            String entityID = this.resolveEntityID(criteria);
            if (entityID != null) {
                this.log.debug("{} Resolved criteria to entityID: {}", (Object)this.getLogPrefix(), (Object)entityID);
                EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
                Lock readLock = mgmtData.getReadWriteLock().readLock();
                try {
                    readLock.lock();
                    List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
                    if (descriptors.isEmpty()) {
                        if (mgmtData.isNegativeLookupCacheActive()) {
                            this.log.debug("{} Did not find requested metadata in backing store, and negative lookup cache is active, returning empty result", (Object)this.getLogPrefix());
                            List<EntityDescriptor> list = Collections.emptyList();
                            return list;
                        }
                        this.log.debug("{} Did not find requested metadata in backing store, attempting to resolve dynamically", (Object)this.getLogPrefix());
                    }
                    if (this.shouldAttemptRefresh(mgmtData)) {
                        this.log.debug("{} Metadata was indicated to be refreshed based on refresh trigger time", (Object)this.getLogPrefix());
                    }
                    this.log.debug("{} Found requested metadata in backing store", (Object)this.getLogPrefix());
                    candidates = descriptors;
                }
                finally {
                    readLock.unlock();
                }
            } else {
                this.log.debug("{} Single entityID unresolveable from criteria, will resolve from origin by criteria only", (Object)this.getLogPrefix());
            }
            if (candidates == null) {
                candidates = this.resolveFromOriginSource(criteria, entityID);
            }
            Iterable<EntityDescriptor> iterable = this.predicateFilterCandidates(candidates, criteria, false);
            return iterable;
        }
        finally {
            MetricsSupport.stopTimer((Timer.Context)contextResolve);
        }
    }

    @Nullable
    protected String resolveEntityID(@Nonnull CriteriaSet criteria) {
        Set<String> entityIDs = this.resolveEntityIDs(criteria);
        if (entityIDs.size() == 1) {
            return entityIDs.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Set<String> resolveEntityIDs(@Nonnull CriteriaSet criteria) {
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (entityIdCriterion != null) {
            this.log.debug("{} Found entityID in criteria: {}", (Object)this.getLogPrefix(), (Object)entityIdCriterion.getEntityId());
            return Collections.singleton(entityIdCriterion.getEntityId());
        }
        this.log.debug("{} EntityID was not supplied in criteria, processing criteria with secondary indexes", (Object)this.getLogPrefix());
        if (!this.indexesEnabled()) {
            this.log.trace("Indexes not enabled, skipping secondary index processing");
            return Collections.emptySet();
        }
        Optional<Object> indexedResult = Optional.empty();
        Lock readLock = this.getBackingStore().getSecondaryIndexManager().getReadWriteLock().readLock();
        try {
            readLock.lock();
            indexedResult = this.getBackingStore().getSecondaryIndexManager().lookupIndexedItems(criteria);
        }
        finally {
            readLock.unlock();
        }
        if (indexedResult.isPresent()) {
            Set entityIDs = (Set)indexedResult.get();
            if (entityIDs.isEmpty()) {
                this.log.debug("{} No entityIDs resolved from secondary indexes (Optional 'present' with empty set)", (Object)this.getLogPrefix());
                return Collections.emptySet();
            }
            if (entityIDs.size() > 1) {
                this.log.debug("{} Multiple entityIDs resolved from secondary indexes: {}", (Object)this.getLogPrefix(), (Object)entityIDs);
                return new HashSet<String>(entityIDs);
            }
            String entityID = (String)entityIDs.iterator().next();
            this.log.debug("{} Resolved 1 entityID from secondary indexes: {}", (Object)this.getLogPrefix(), (Object)entityID);
            return Collections.singleton(entityID);
        }
        this.log.debug("{} No entityIDs resolved from secondary indexes (Optional 'absent').", (Object)this.getLogPrefix());
        return null;
    }

    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> resolveFromOriginSource(@Nonnull CriteriaSet criteria, @Nullable String entityID) throws ResolverException {
        if (entityID != null) {
            this.log.debug("{} Resolving from origin source based on entityID: {}", (Object)this.getLogPrefix(), (Object)entityID);
            return this.resolveFromOriginSourceWithEntityID(criteria, entityID);
        }
        this.log.debug("{} Resolving from origin source based on non-entityID criteria", (Object)this.getLogPrefix());
        return this.resolveFromOriginSourceWithoutEntityID(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> resolveFromOriginSourceWithEntityID(@Nonnull CriteriaSet criteria, @Nonnull String entityID) throws ResolverException {
        EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
        Lock writeLock = mgmtData.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
            if (!descriptors.isEmpty() && !this.shouldAttemptRefresh(mgmtData)) {
                this.log.debug("{} Metadata was resolved and stored by another thread while this thread was waiting on the write lock", (Object)this.getLogPrefix());
                List<EntityDescriptor> list = descriptors;
                return list;
            }
            this.log.debug("{} Resolving metadata dynamically for entity ID: {}", (Object)this.getLogPrefix(), (Object)entityID);
            Timer.Context contextFetchFromOriginSource = MetricsSupport.startTimer((com.codahale.metrics.Timer)this.timerFetchFromOriginSource);
            XMLObject root = null;
            try {
                root = this.fetchFromOriginSource(criteria);
            }
            finally {
                MetricsSupport.stopTimer((Timer.Context)contextFetchFromOriginSource);
            }
            if (root == null) {
                mgmtData.initNegativeLookupCache();
                this.log.debug("{} No metadata was fetched from the origin source", (Object)this.getLogPrefix());
                if (!descriptors.isEmpty()) {
                    mgmtData.setRefreshTriggerTime(this.computeRefreshTriggerTime(mgmtData.getExpirationTime(), Instant.now()));
                    this.log.debug("{} Had existing data, recalculated refresh trigger time as: {}", (Object)this.getLogPrefix(), (Object)mgmtData.getRefreshTriggerTime());
                }
            } else {
                mgmtData.clearNegativeLookupCache();
                try {
                    this.processNewMetadata(root, entityID);
                }
                catch (FilterException e) {
                    this.log.error("{} Metadata filtering problem processing new metadata", (Object)this.getLogPrefix(), (Object)e);
                }
            }
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        catch (IOException e) {
            this.log.error("{} Error fetching metadata from origin source", (Object)this.getLogPrefix(), (Object)e);
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> resolveFromOriginSourceWithoutEntityID(@Nonnull CriteriaSet criteria) throws ResolverException {
        XMLObject root = null;
        Timer.Context contextFetchFromOriginSource = MetricsSupport.startTimer((com.codahale.metrics.Timer)this.timerFetchFromOriginSource);
        try {
            root = this.fetchFromOriginSource(criteria);
        }
        catch (IOException e) {
            this.log.error("{} Error fetching metadata from origin source", (Object)this.getLogPrefix(), (Object)e);
            Iterable<EntityDescriptor> iterable = this.lookupCriteria(criteria);
            return iterable;
        }
        finally {
            MetricsSupport.stopTimer((Timer.Context)contextFetchFromOriginSource);
        }
        if (root == null) {
            this.log.debug("{} No metadata was fetched from the origin source", (Object)this.getLogPrefix());
            return this.lookupCriteria(criteria);
        }
        if (root instanceof EntityDescriptor) {
            this.log.debug("{} Fetched EntityDescriptor from the origin source", (Object)this.getLogPrefix());
            return this.processNonEntityIDFetchedEntityDescriptor((EntityDescriptor)root);
        }
        if (root instanceof EntitiesDescriptor) {
            this.log.debug("{} Fetched EntitiesDescriptor from the origin source", (Object)this.getLogPrefix());
            return this.processNonEntityIDFetchedEntittiesDescriptor((EntitiesDescriptor)root);
        }
        this.log.warn("{} Fetched metadata was of an unsupported type: {}", (Object)this.getLogPrefix(), (Object)root.getClass().getName());
        return this.lookupCriteria(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> lookupCriteria(@Nonnull CriteriaSet criteria) throws ResolverException {
        ArrayList<EntityDescriptor> entities = new ArrayList<EntityDescriptor>();
        Set<String> entityIDs = this.resolveEntityIDs(criteria);
        for (String entityID : entityIDs) {
            EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
            Lock readLock = mgmtData.getReadWriteLock().readLock();
            try {
                readLock.lock();
                entities.addAll(this.lookupEntityID(entityID));
            }
            finally {
                readLock.unlock();
            }
        }
        return entities;
    }

    @Nullable
    protected List<EntityDescriptor> processNonEntityIDFetchedEntittiesDescriptor(@Nonnull EntitiesDescriptor entities) throws ResolverException {
        ArrayList<EntityDescriptor> returnedEntities = new ArrayList<EntityDescriptor>();
        for (EntitiesDescriptor childEntities : entities.getEntitiesDescriptors()) {
            returnedEntities.addAll(this.processNonEntityIDFetchedEntittiesDescriptor(childEntities));
        }
        for (EntityDescriptor entity : entities.getEntityDescriptors()) {
            returnedEntities.addAll(this.processNonEntityIDFetchedEntityDescriptor(entity));
        }
        return returnedEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected List<EntityDescriptor> processNonEntityIDFetchedEntityDescriptor(@Nonnull EntityDescriptor entity) throws ResolverException {
        String entityID = entity.getEntityID();
        EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
        Lock writeLock = mgmtData.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            mgmtData.clearNegativeLookupCache();
            this.processNewMetadata((XMLObject)entity, entityID);
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        catch (FilterException e) {
            this.log.error("{} Metadata filtering problem processing non-entityID fetched EntityDescriptor", (Object)this.getLogPrefix(), (Object)e);
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nullable
    protected abstract XMLObject fetchFromOriginSource(@Nonnull CriteriaSet var1) throws IOException;

    @Override
    @Nonnull
    @NonnullElements
    protected List<EntityDescriptor> lookupEntityID(@Nonnull String entityID) throws ResolverException {
        this.getBackingStore().getManagementData(entityID).recordEntityAccess();
        return super.lookupEntityID(entityID);
    }

    @Nonnull
    protected void processNewMetadata(@Nonnull XMLObject root, @Nonnull String expectedEntityID) throws FilterException {
        try {
            this.processNewMetadata(root, expectedEntityID, false);
        }
        catch (ResolverException e) {
            throw new FilterException((Exception)((Object)e));
        }
    }

    @Nonnull
    protected void processNewMetadata(@Nonnull XMLObject root, @Nonnull String expectedEntityID, boolean fromPersistentCache) throws FilterException, ResolverException {
        XMLObject filteredMetadata = this.filterMetadata(this.prepareForFiltering(root));
        if (filteredMetadata == null) {
            this.log.info("{} Metadata filtering process produced a null document, resulting in an empty data set", (Object)this.getLogPrefix());
            this.releaseMetadataDOM(root);
            if (fromPersistentCache) {
                throw new FilterException("Metadata filtering process produced a null XMLObject");
            }
            return;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)filteredMetadata;
            if (!Objects.equals(entityDescriptor.getEntityID(), expectedEntityID)) {
                this.log.warn("{} New metadata's entityID '{}' does not match expected entityID '{}', will not process", new Object[]{this.getLogPrefix(), entityDescriptor.getEntityID(), expectedEntityID});
                if (fromPersistentCache) {
                    throw new ResolverException("New metadata's entityID does not match expected entityID");
                }
                return;
            }
            this.preProcessEntityDescriptor(entityDescriptor, this.getBackingStore());
            this.log.info("{} Successfully loaded new EntityDescriptor with entityID '{}' from {}", new Object[]{this.getLogPrefix(), entityDescriptor.getEntityID(), fromPersistentCache ? "persistent cache" : "origin source"});
            if (this.isPersistentCachingEnabled() && !fromPersistentCache && root instanceof EntityDescriptor) {
                EntityDescriptor origDescriptor = (EntityDescriptor)root;
                String key = this.getPersistentCacheKeyGenerator().apply(origDescriptor);
                this.log.trace("{} Storing resolved EntityDescriptor '{}' in persistent cache with key '{}'", new Object[]{this.getLogPrefix(), origDescriptor.getEntityID(), key});
                if (key == null) {
                    this.log.warn("{} Could not generate cache storage key for EntityDescriptor '{}', skipping caching", (Object)this.getLogPrefix(), (Object)origDescriptor.getEntityID());
                } else {
                    try {
                        this.getPersistentCacheManager().save(key, (XMLObject)origDescriptor, true);
                    }
                    catch (IOException e) {
                        this.log.warn("{} Error saving EntityDescriptor '{}' to cache store with key {}'", new Object[]{this.getLogPrefix(), origDescriptor.getEntityID(), key});
                    }
                }
            }
        } else {
            this.log.warn("{} Document root was not an EntityDescriptor: {}", (Object)this.getLogPrefix(), (Object)root.getClass().getName());
        }
        this.releaseMetadataDOM(filteredMetadata);
        this.releaseMetadataDOM(root);
    }

    @Nonnull
    protected XMLObject prepareForFiltering(@Nonnull XMLObject input) {
        if (this.getMetadataFilter() != null && this.isPersistentCachingEnabled()) {
            try {
                return XMLObjectSupport.cloneXMLObject((XMLObject)input, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.RootDOMInNewDocument);
            }
            catch (MarshallingException | UnmarshallingException e) {
                this.log.warn("{} Error cloning XMLObject, will use input root object as filter target", (Object)this.getLogPrefix(), (Object)e);
                return input;
            }
        }
        return input;
    }

    @Override
    protected void preProcessEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull AbstractMetadataResolver.EntityBackingStore backingStore) {
        String entityID = StringSupport.trimOrNull((String)entityDescriptor.getEntityID());
        this.removeByEntityID(entityID, backingStore);
        super.preProcessEntityDescriptor(entityDescriptor, backingStore);
        DynamicEntityBackingStore dynamicBackingStore = (DynamicEntityBackingStore)backingStore;
        EntityManagementData mgmtData = dynamicBackingStore.getManagementData(entityID);
        Instant now = Instant.now();
        this.log.debug("{} For metadata expiration and refresh computation, 'now' is : {}", (Object)this.getLogPrefix(), (Object)now);
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(this.computeExpirationTime(entityDescriptor, now));
        this.log.debug("{} Computed metadata expiration time: {}", (Object)this.getLogPrefix(), (Object)mgmtData.getExpirationTime());
        mgmtData.setRefreshTriggerTime(this.computeRefreshTriggerTime(mgmtData.getExpirationTime(), now));
        this.log.debug("{} Computed refresh trigger time: {}", (Object)this.getLogPrefix(), (Object)mgmtData.getRefreshTriggerTime());
        this.logMetadataExpiration(entityDescriptor, now, mgmtData.getRefreshTriggerTime());
    }

    private void logMetadataExpiration(@Nonnull EntityDescriptor descriptor, @Nonnull Instant now, @Nonnull Instant nextRefresh) {
        if (!this.isValid((XMLObject)descriptor)) {
            this.log.warn("{} Metadata with ID '{}' currently live is expired or otherwise invalid", (Object)this.getLogPrefix(), (Object)descriptor.getEntityID());
        } else if (this.isRequireValidMetadata() && descriptor.getValidUntil() != null) {
            if (!this.getExpirationWarningThreshold().isZero() && descriptor.getValidUntil().isBefore(now.plus(this.getExpirationWarningThreshold()))) {
                this.log.warn("{} Metadata with ID '{}' currently live will expire within the configured threshhold at '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), descriptor.getValidUntil()});
            } else if (descriptor.getValidUntil().isBefore(nextRefresh)) {
                this.log.warn("{} Metadata with ID '{}' currently live will expire at '{}' before the next refresh scheduled for {}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), descriptor.getValidUntil(), nextRefresh});
            }
        }
    }

    @Nonnull
    protected Instant computeExpirationTime(@Nonnull EntityDescriptor entityDescriptor, @Nonnull Instant now) {
        Instant lowerBound = now.plus(this.getMinCacheDuration());
        Instant expiration = SAML2Support.getEarliestExpiration((XMLObject)entityDescriptor, (Instant)now.plus(this.getMaxCacheDuration()), (Instant)now);
        if (expiration.isBefore(lowerBound)) {
            expiration = lowerBound;
        }
        return expiration;
    }

    @Nonnull
    protected Instant computeRefreshTriggerTime(@Nullable Instant expirationTime, @Nonnull Instant nowDateTime) {
        long refreshDelay;
        long now = nowDateTime.toEpochMilli();
        long expireInstant = 0L;
        if (expirationTime != null) {
            expireInstant = expirationTime.toEpochMilli();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor().floatValue())) < this.getMinCacheDuration().toMillis()) {
            refreshDelay = this.getMinCacheDuration().toMillis();
        }
        return nowDateTime.plusMillis(refreshDelay);
    }

    protected boolean shouldAttemptRefresh(@Nonnull EntityManagementData mgmtData) {
        return Instant.now().isAfter(mgmtData.getRefreshTriggerTime());
    }

    @Override
    @Nonnull
    protected DynamicEntityBackingStore createNewBackingStore() {
        return new DynamicEntityBackingStore(this.getIndexes());
    }

    @Override
    @NonnullAfterInit
    protected DynamicEntityBackingStore getBackingStore() {
        return (DynamicEntityBackingStore)super.getBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        try {
            this.initializing = true;
            super.initMetadataResolver();
            this.initializeMetricsInstrumentation();
            this.setBackingStore(this.createNewBackingStore());
            if (this.getPersistentCacheKeyGenerator() == null) {
                this.setPersistentCacheKeyGenerator(new DefaultCacheKeyGenerator());
            }
            if (this.getInitializationFromCachePredicate() == null) {
                this.setInitializationFromCachePredicate((Predicate<EntityDescriptor>)Predicates.alwaysTrue());
            }
            this.persistentCacheInitMetrics = new PersistentCacheInitializationMetrics();
            if (this.isPersistentCachingEnabled()) {
                this.persistentCacheInitMetrics.enabled = true;
                if (this.isInitializeFromPersistentCacheInBackground()) {
                    this.log.debug("{} Initializing from the persistent cache in the background in {} ms", (Object)this.getLogPrefix(), (Object)this.getBackgroundInitializationFromCacheDelay());
                    TimerTask initTask = new TimerTask(){

                        @Override
                        public void run() {
                            AbstractDynamicMetadataResolver.this.initializeFromPersistentCache();
                        }
                    };
                    this.taskTimer.schedule(initTask, this.getBackgroundInitializationFromCacheDelay().toMillis());
                } else {
                    this.log.debug("{} Initializing from the persistent cache in the foreground", (Object)this.getLogPrefix());
                    this.initializeFromPersistentCache();
                }
            }
            this.cleanupTask = new BackingStoreCleanupSweeper();
            this.taskTimer.schedule((TimerTask)this.cleanupTask, 60000L, this.getCleanupTaskInterval().toMillis());
        }
        finally {
            this.initializing = false;
        }
    }

    private void initializeMetricsInstrumentation() {
        MetricRegistry metricRegistry;
        if (this.getMetricsBaseName() == null) {
            this.setMetricsBaseName(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{this.getId()}));
        }
        if ((metricRegistry = MetricsSupport.getMetricRegistry()) != null) {
            this.timerResolve = metricRegistry.timer(MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_TIMER_RESOLVE}));
            this.timerFetchFromOriginSource = metricRegistry.timer(MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_TIMER_FETCH_FROM_ORIGIN_SOURCE}));
            this.ratioGaugeFetchToResolve = (RatioGauge)MetricsSupport.register((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_RATIOGAUGE_FETCH_TO_RESOLVE}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractDynamicMetadataResolver.this.timerFetchFromOriginSource.getCount(), (double)AbstractDynamicMetadataResolver.this.timerResolve.getCount());
                }
            }, (boolean)true);
            this.gaugeNumLiveEntityIDs = (Gauge)MetricsSupport.register((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_GAUGE_NUM_LIVE_ENTITYIDS}), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return AbstractDynamicMetadataResolver.this.getBackingStore().getIndexedDescriptors().keySet().size();
                }
            }, (boolean)true);
            this.gaugePersistentCacheInit = (Gauge)MetricsSupport.register((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_GAUGE_PERSISTENT_CACHE_INIT}), (Metric)new Gauge<PersistentCacheInitializationMetrics>(){

                public PersistentCacheInitializationMetrics getValue() {
                    return AbstractDynamicMetadataResolver.this.persistentCacheInitMetrics;
                }
            }, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFromPersistentCache() {
        if (!this.isPersistentCachingEnabled()) {
            this.log.trace("{} Persistent caching is not enabled, skipping init from cache", (Object)this.getLogPrefix());
            return;
        }
        this.log.trace("{} Attempting to load and process entities from the persistent cache", (Object)this.getLogPrefix());
        long start = System.nanoTime();
        try {
            for (Pair cacheEntry : this.getPersistentCacheManager().listAll()) {
                ++this.persistentCacheInitMetrics.entriesTotal;
                EntityDescriptor descriptor = (EntityDescriptor)cacheEntry.getSecond();
                String currentKey = (String)cacheEntry.getFirst();
                this.log.trace("{} Loaded EntityDescriptor from cache store with entityID '{}' and storage key '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), currentKey});
                String entityID = StringSupport.trimOrNull((String)descriptor.getEntityID());
                EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
                Lock writeLock = mgmtData.getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (!this.lookupIndexedEntityID(entityID).isEmpty()) {
                        this.log.trace("{} Metadata for entityID '{}' found in persistent cache was already live, ignoring cached entry", (Object)this.getLogPrefix(), (Object)entityID);
                        ++this.persistentCacheInitMetrics.entriesSkippedAlreadyLive;
                        continue;
                    }
                    this.processPersistentCacheEntry(currentKey, descriptor);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        catch (IOException e) {
            this.log.warn("{} Error loading EntityDescriptors from cache", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            this.persistentCacheInitMetrics.processingTime = System.nanoTime() - start;
            this.log.debug("{} Persistent cache initialization metrics: {}", (Object)this.getLogPrefix(), (Object)this.persistentCacheInitMetrics);
        }
    }

    protected void processPersistentCacheEntry(@Nonnull String currentKey, @Nonnull EntityDescriptor descriptor) {
        if (this.isValid((XMLObject)descriptor)) {
            if (this.getInitializationFromCachePredicate().test(descriptor)) {
                try {
                    this.processNewMetadata((XMLObject)descriptor, descriptor.getEntityID(), true);
                    this.log.trace("{} Successfully processed EntityDescriptor with entityID '{}' from cache", (Object)this.getLogPrefix(), (Object)descriptor.getEntityID());
                    ++this.persistentCacheInitMetrics.entriesLoaded;
                }
                catch (ResolverException | FilterException e) {
                    this.log.warn("{} Error processing EntityDescriptor '{}' from cache with storage key '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), currentKey, e});
                    ++this.persistentCacheInitMetrics.entriesSkippedProcessingException;
                }
            } else {
                this.log.trace("{} Cache initialization predicate indicated to not process EntityDescriptor with entityID '{}' and cache storage key '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), currentKey});
                ++this.persistentCacheInitMetrics.entriesSkippedFailedPredicate;
            }
            String expectedKey = this.getPersistentCacheKeyGenerator().apply(descriptor);
            try {
                if (!Objects.equals(currentKey, expectedKey)) {
                    this.log.trace("{} Current cache storage key '{}' differs from expected key '{}', updating", new Object[]{this.getLogPrefix(), currentKey, expectedKey});
                    this.getPersistentCacheManager().updateKey(currentKey, expectedKey);
                    this.log.trace("{} Successfully updated cache storage key '{}' to '{}'", new Object[]{this.getLogPrefix(), currentKey, expectedKey});
                }
            }
            catch (IOException e) {
                this.log.warn("{} Error updating cache storage key '{}' to '{}'", new Object[]{this.getLogPrefix(), currentKey, expectedKey, e});
            }
        } else {
            this.log.trace("{} EntityDescriptor with entityID '{}' and storaage key '{}' in cache was not valid, skipping and removing", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), currentKey});
            ++this.persistentCacheInitMetrics.entriesSkippedInvalid;
            try {
                this.getPersistentCacheManager().remove(currentKey);
            }
            catch (IOException e) {
                this.log.warn("{} Error removing invalid EntityDescriptor '{}' from persistent cache with key '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), currentKey});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeByEntityID(String entityID, AbstractMetadataResolver.EntityBackingStore backingStore) {
        List<EntityDescriptor> descriptors = backingStore.getIndexedDescriptors().get(entityID);
        if (descriptors != null) {
            for (EntityDescriptor descriptor : descriptors) {
                if (this.indexesEnabled()) {
                    DynamicEntityBackingStore dynamicStore = (DynamicEntityBackingStore)backingStore;
                    Lock writeLock = dynamicStore.getSecondaryIndexManager().getReadWriteLock().writeLock();
                    try {
                        writeLock.lock();
                        dynamicStore.getSecondaryIndexManager().deindexEntityDescriptor(descriptor);
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                if (!this.isPersistentCachingEnabled()) continue;
                String key = this.getPersistentCacheKeyGenerator().apply(descriptor);
                try {
                    this.getPersistentCacheManager().remove(key);
                }
                catch (IOException e) {
                    this.log.warn("{} Error removing EntityDescriptor '{}' from cache store with key '{}'", new Object[]{this.getLogPrefix(), descriptor.getEntityID(), key});
                }
            }
        }
        super.removeByEntityID(entityID, backingStore);
    }

    @Override
    protected void doDestroy() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        this.cleanupTask = null;
        this.taskTimer = null;
        if (this.ratioGaugeFetchToResolve != null) {
            MetricsSupport.remove((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_RATIOGAUGE_FETCH_TO_RESOLVE}), (Metric)this.ratioGaugeFetchToResolve);
        }
        if (this.gaugeNumLiveEntityIDs != null) {
            MetricsSupport.remove((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_GAUGE_NUM_LIVE_ENTITYIDS}), this.gaugeNumLiveEntityIDs);
        }
        if (this.gaugePersistentCacheInit != null) {
            MetricsSupport.remove((String)MetricRegistry.name((String)this.getMetricsBaseName(), (String[])new String[]{METRIC_GAUGE_PERSISTENT_CACHE_INIT}), this.gaugePersistentCacheInit);
        }
        this.ratioGaugeFetchToResolve = null;
        this.gaugeNumLiveEntityIDs = null;
        this.gaugePersistentCacheInit = null;
        this.timerFetchFromOriginSource = null;
        this.timerResolve = null;
        super.doDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indexEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull AbstractMetadataResolver.EntityBackingStore backingStore) {
        super.indexEntityDescriptor(entityDescriptor, backingStore);
        if (this.indexesEnabled()) {
            DynamicEntityBackingStore dynamicStore = (DynamicEntityBackingStore)backingStore;
            Lock writeLock = dynamicStore.getSecondaryIndexManager().getReadWriteLock().writeLock();
            try {
                writeLock.lock();
                dynamicStore.getSecondaryIndexManager().indexEntityDescriptor(entityDescriptor);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    protected class DynamicEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        private Map<String, EntityManagementData> mgmtDataMap;
        private LockableMetadataIndexManager<String> secondaryIndexManager;

        protected DynamicEntityBackingStore(Set<MetadataIndex> initIndexes) {
            super(AbstractDynamicMetadataResolver.this);
            this.mgmtDataMap = new ConcurrentHashMap<String, EntityManagementData>();
            this.secondaryIndexManager = new LockableMetadataIndexManager<String>(initIndexes, new MetadataIndexManager.EntityIDExtractionFunction());
        }

        public LockableMetadataIndexManager<String> getSecondaryIndexManager() {
            return this.secondaryIndexManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        @NonnullElements
        @Unmodifiable
        @NotLive
        public Set<String> getManagementDataEntityIDs() {
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                return Set.copyOf(this.mgmtDataMap.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public EntityManagementData getManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            EntityManagementData entityData = this.mgmtDataMap.get(entityID);
            if (entityData != null) {
                return entityData;
            }
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                entityData = this.mgmtDataMap.get(entityID);
                if (entityData != null) {
                    return entityData;
                }
                entityData = new EntityManagementData(entityID);
                this.mgmtDataMap.put(entityID, entityData);
                return entityData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                this.mgmtDataMap.remove(entityID);
            }
        }
    }

    protected class EntityManagementData {
        private String entityID;
        private Instant lastUpdateTime;
        private Instant expirationTime;
        private Instant refreshTriggerTime;
        private Instant lastAccessedTime;
        private Instant negativeLookupCacheExpiration;
        private ReadWriteLock readWriteLock;

        protected EntityManagementData(String id) {
            this.entityID = (String)Constraint.isNotNull((Object)id, (String)"Entity ID was null");
            Instant now = Instant.now();
            this.expirationTime = now.plus(AbstractDynamicMetadataResolver.this.getMaxCacheDuration());
            this.refreshTriggerTime = now.plus(AbstractDynamicMetadataResolver.this.getMaxCacheDuration());
            this.lastAccessedTime = now;
            this.readWriteLock = new ReentrantReadWriteLock(true);
        }

        @Nonnull
        public String getEntityID() {
            return this.entityID;
        }

        @Nullable
        public Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(@Nonnull Instant dateTime) {
            this.lastUpdateTime = dateTime;
        }

        @Nonnull
        public Instant getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(@Nonnull Instant dateTime) {
            this.expirationTime = (Instant)Constraint.isNotNull((Object)dateTime, (String)"Expiration time may not be null");
        }

        @Nonnull
        public Instant getRefreshTriggerTime() {
            return this.refreshTriggerTime;
        }

        public void setRefreshTriggerTime(@Nonnull Instant dateTime) {
            this.refreshTriggerTime = (Instant)Constraint.isNotNull((Object)dateTime, (String)"Refresh trigger time may not be null");
        }

        @Nonnull
        public Instant getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void recordEntityAccess() {
            this.lastAccessedTime = Instant.now();
        }

        public boolean isNegativeLookupCacheActive() {
            return this.negativeLookupCacheExpiration != null && Instant.now().isBefore(this.negativeLookupCacheExpiration);
        }

        public Instant initNegativeLookupCache() {
            this.negativeLookupCacheExpiration = Instant.now().plus(AbstractDynamicMetadataResolver.this.getNegativeLookupCacheDuration());
            return this.negativeLookupCacheExpiration;
        }

        public void clearNegativeLookupCache() {
            this.negativeLookupCacheExpiration = null;
        }

        @Nonnull
        public ReadWriteLock getReadWriteLock() {
            return this.readWriteLock;
        }
    }

    public static class DefaultCacheKeyGenerator
    implements Function<EntityDescriptor, String> {
        private StringDigester digester;

        public DefaultCacheKeyGenerator() {
            try {
                this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }

        @Override
        public String apply(EntityDescriptor input) {
            if (input == null) {
                return null;
            }
            String entityID = StringSupport.trimOrNull((String)input.getEntityID());
            if (entityID == null) {
                return null;
            }
            return this.digester.apply(entityID);
        }
    }

    public static class PersistentCacheInitializationMetrics {
        private boolean enabled;
        private long processingTime;
        private int entriesTotal;
        private int entriesLoaded;
        private int entriesSkippedAlreadyLive;
        private int entriesSkippedInvalid;
        private int entriesSkippedFailedPredicate;
        private int entriesSkippedProcessingException;

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getProcessingTime() {
            return this.processingTime;
        }

        public int getEntriesTotal() {
            return this.entriesTotal;
        }

        public int getEntriesLoaded() {
            return this.entriesLoaded;
        }

        public int getEntriesSkippedAlreadyLive() {
            return this.entriesSkippedAlreadyLive;
        }

        public int getEntriesSkippedInvalid() {
            return this.entriesSkippedInvalid;
        }

        public int getEntriesSkippedFailedPredicate() {
            return this.entriesSkippedFailedPredicate;
        }

        public int getEntriesSkippedProcessingException() {
            return this.entriesSkippedProcessingException;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("processingTime", this.processingTime).add("entriesTotal", this.entriesTotal).add("entriesLoaded", this.entriesLoaded).add("entriesSkippedAlreadyLive", this.entriesSkippedAlreadyLive).add("entriesSkippedInvalid", this.entriesSkippedInvalid).add("entriesSkippedFailedPredicate", this.entriesSkippedFailedPredicate).add("entriesSkippedProcessingException", this.entriesSkippedProcessingException).toString();
        }
    }

    protected class BackingStoreCleanupSweeper
    extends TimerTask {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(BackingStoreCleanupSweeper.class);

        protected BackingStoreCleanupSweeper() {
        }

        @Override
        public void run() {
            if (AbstractDynamicMetadataResolver.this.isDestroyed() || !AbstractDynamicMetadataResolver.this.isInitialized()) {
                this.log.debug("{} BackingStoreCleanupSweeper will not run because: inited: {}, destroyed: {}", new Object[]{AbstractDynamicMetadataResolver.this.getLogPrefix(), AbstractDynamicMetadataResolver.this.isInitialized(), AbstractDynamicMetadataResolver.this.isDestroyed()});
                return;
            }
            this.removeExpiredAndIdleMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeExpiredAndIdleMetadata() {
            Instant now = Instant.now();
            Instant earliestValidLastAccessed = now.minus(AbstractDynamicMetadataResolver.this.getMaxIdleEntityData());
            DynamicEntityBackingStore backingStore = AbstractDynamicMetadataResolver.this.getBackingStore();
            HashSet<String> entityIDs = new HashSet<String>();
            entityIDs.addAll(backingStore.getIndexedDescriptors().keySet());
            entityIDs.addAll(backingStore.getManagementDataEntityIDs());
            for (String entityID : entityIDs) {
                EntityManagementData mgmtData = backingStore.getManagementData(entityID);
                Lock writeLock = mgmtData.getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (!this.isRemoveData(mgmtData, now, earliestValidLastAccessed)) continue;
                    AbstractDynamicMetadataResolver.this.removeByEntityID(entityID, backingStore);
                    backingStore.removeManagementData(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }

        private boolean isRemoveData(@Nonnull EntityManagementData mgmtData, @Nonnull Instant now, @Nonnull Instant earliestValidLastAccessed) {
            if (AbstractDynamicMetadataResolver.this.isRemoveIdleEntityData() && mgmtData.getLastAccessedTime().isBefore(earliestValidLastAccessed)) {
                this.log.debug("{} Entity metadata exceeds maximum idle time, removing: {}", (Object)AbstractDynamicMetadataResolver.this.getLogPrefix(), (Object)mgmtData.getEntityID());
                return true;
            }
            if (now.isAfter(mgmtData.getExpirationTime())) {
                this.log.debug("{} Entity metadata is expired, removing: {}", (Object)AbstractDynamicMetadataResolver.this.getLogPrefix(), (Object)mgmtData.getEntityID());
                return true;
            }
            return false;
        }
    }
}

