/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;

public class CheckValidConnectionSQL
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -222752863430216887L;
    private static final String VALIDATION_QUERY_TIMEOUT = "ironjacamar.validation_query_timeout";
    private String sql;
    private int queryTimeout;

    public CheckValidConnectionSQL() {
        String value = SecurityActions.getSystemProperty(VALIDATION_QUERY_TIMEOUT);
        if (value != null && !value.trim().equals("")) {
            try {
                this.queryTimeout = Integer.valueOf(value);
            }
            catch (Throwable t) {
                this.queryTimeout = 0;
            }
        }
    }

    public CheckValidConnectionSQL(String sql) {
        this();
        this.sql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        SQLException sQLException;
        if (this.sql == null) {
            return null;
        }
        Statement s = c.createStatement();
        try {
            s.setQueryTimeout(this.queryTimeout);
            s.execute(this.sql);
            sQLException = null;
        }
        catch (Throwable throwable) {
            try {
                s.close();
                throw throwable;
            }
            catch (SQLException e) {
                return e;
            }
        }
        s.close();
        return sQLException;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }
}

