/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi;

import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi.Flag;
import org.wildfly.security.auth.jaspi._private.ElytronEEMessages;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.AuthenticationModuleDefinition;
import org.wildfly.security.auth.jaspi.impl.ElytronAuthConfigProvider;

public class ElytronAuthConfigFactory
extends AuthConfigFactory {
    private static final String SERVLET_MESSAGE_LAYER = "HttpServlet";
    private static final String REGISTRATION_KEY = ElytronAuthConfigFactory.class.getName() + ".registration";
    private final Map<LayerContextKey, Registration> layerContextRegistration = new HashMap<LayerContextKey, Registration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            LayerContextKey fullKey = new LayerContextKey(layer, appContext);
            Registration registration = this.layerContextRegistration.get(fullKey);
            if (registration != null) {
                if (listener != null) {
                    registration.addListener(listener);
                }
                if (registration.activeRegistration()) {
                    return registration.authConfigProvider;
                }
            } else if (listener != null) {
                Registration listenerRegistration = new Registration(layer, appContext);
                listenerRegistration.addListener(listener);
                this.layerContextRegistration.put(fullKey, listenerRegistration);
            }
            if (layer != null && (registration = this.layerContextRegistration.get(new LayerContextKey(null, appContext))) != null && registration.activeRegistration()) {
                return registration.authConfigProvider;
            }
            if (appContext != null && (registration = this.layerContextRegistration.get(new LayerContextKey(layer, null))) != null && registration.activeRegistration()) {
                return registration.authConfigProvider;
            }
            if (layer != null && appContext != null && (registration = this.layerContextRegistration.get(new LayerContextKey(null, null))) != null && registration.activeRegistration()) {
                return registration.authConfigProvider;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesRegistration(String layer, String appContext) {
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            Registration registration = this.layerContextRegistration.get(new LayerContextKey(layer, appContext));
            if (registration != null && registration.activeRegistration()) {
                return true;
            }
            registration = this.layerContextRegistration.get(new LayerContextKey(null, appContext));
            if (registration != null && registration.activeRegistration()) {
                return true;
            }
            registration = this.layerContextRegistration.get(new LayerContextKey(layer, null));
            if (registration != null && registration.activeRegistration()) {
                return true;
            }
            registration = this.layerContextRegistration.get(new LayerContextKey(null, null));
            if (registration != null && registration.activeRegistration()) {
                return true;
            }
        }
        return false;
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        return this.registerConfigProvider(provider, layer, appContext, description, false);
    }

    public String registerConfigProvider(String className, Map<String, String> properties, String layer, String appContext, String description) {
        AuthConfigProvider authConfigProvider = null;
        if (className != null) {
            ClassLoader classLoader = ElytronAuthConfigFactory.identifyClassLoader();
            try {
                Class<?> providerClass = classLoader.loadClass(className);
                Constructor<?> constructor = providerClass.getConstructor(Map.class, AuthConfigFactory.class);
                authConfigProvider = (AuthConfigProvider)constructor.newInstance(properties, null);
            }
            catch (Exception e) {
                throw ElytronMessages.log.unableToConstructProvider(className, e);
            }
        }
        return this.registerConfigProvider(authConfigProvider, layer, appContext, description, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description, boolean persistent) {
        List<Object> existingListeners;
        Registration registration = null;
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            LayerContextKey layerContextKey = new LayerContextKey(layer, appContext);
            registration = this.layerContextRegistration.get(layerContextKey);
            if (registration == null) {
                registration = new Registration(layer, appContext);
                this.layerContextRegistration.put(layerContextKey, registration);
                existingListeners = Collections.emptyList();
            } else {
                existingListeners = registration.clearListeners();
            }
            registration.setDescription(description);
            registration.setPersistent(persistent);
            registration.setAuthConfigProvider(provider, provider == null);
        }
        for (RegistrationListener registrationListener : existingListeners) {
            registrationListener.notify(layer, appContext);
        }
        return registration.getRegistrationId();
    }

    public String registerServerAuthModule(ServerAuthModule module, Object context) {
        Assert.checkNotNullParam((String)"module", (Object)module);
        Assert.checkNotNullParam((String)"context", (Object)context);
        String layer = ElytronAuthConfigFactory.toLayer(context);
        String appContext = ElytronAuthConfigFactory.toApplicationContext(context);
        ElytronMessages.log.tracef("Registering ServerAuthModule for Layer=%s, AppContext=%s", layer, appContext);
        String registration = this.registerConfigProvider(new ElytronAuthConfigProvider(layer, appContext, Collections.singletonList(new AuthenticationModuleDefinition(() -> module, Flag.REQUIRED, Collections.emptyMap()))), layer, appContext, module.getClass().getName());
        ElytronAuthConfigFactory.saveRegistration(registration, context);
        return registration;
    }

    public void removeServerAuthModule(Object context) {
        Assert.checkNotNullParam((String)"context", (Object)context);
        this.removeRegistration(ElytronAuthConfigFactory.getRegistration(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRegistration(String registrationId) {
        String layer = null;
        String appContext = null;
        boolean removed = false;
        List<RegistrationListener> existingListeners = null;
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            Iterator<Map.Entry<LayerContextKey, Registration>> registrationIterator = this.layerContextRegistration.entrySet().iterator();
            while (registrationIterator.hasNext()) {
                Map.Entry<LayerContextKey, Registration> entry = registrationIterator.next();
                if (!entry.getValue().getRegistrationId().equals(registrationId)) continue;
                existingListeners = entry.getValue().clearListeners();
                layer = entry.getKey().messageLayer;
                appContext = entry.getKey().appContext;
                registrationIterator.remove();
                removed = true;
                break;
            }
        }
        if (existingListeners != null && !existingListeners.isEmpty()) {
            for (RegistrationListener current : existingListeners) {
                current.notify(layer, appContext);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        Assert.checkNotNullParam((String)"listener", (Object)listener);
        ArrayList<String> registrationIDs = new ArrayList<String>();
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            for (Registration current : this.layerContextRegistration.values()) {
                if (layer != null && !layer.equals(current.messageLayer) || appContext != null && !appContext.equals(current.appContext) || !current.removeListener(listener)) continue;
                registrationIDs.add(current.getRegistrationId());
            }
        }
        return registrationIDs.toArray(new String[registrationIDs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            for (Registration current : this.layerContextRegistration.values()) {
                if (!current.getRegistrationId().equals(registrationID)) continue;
                return current.toRegistrationContext();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        ArrayList<String> registrationIDs = new ArrayList<String>();
        Map<LayerContextKey, Registration> map = this.layerContextRegistration;
        synchronized (map) {
            if (provider != null) {
                for (Registration current : this.layerContextRegistration.values()) {
                    if (!provider.equals((Object)current.authConfigProvider)) continue;
                    registrationIDs.add(current.registrationId);
                }
            } else {
                for (Registration current : this.layerContextRegistration.values()) {
                    if (!current.activeRegistration()) continue;
                    registrationIDs.add(current.registrationId);
                }
            }
        }
        return registrationIDs.toArray(new String[registrationIDs.size()]);
    }

    public void refresh() {
    }

    private static ClassLoader identifyClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    private static String toLayer(Object context) {
        if (context instanceof ServletContext) {
            return SERVLET_MESSAGE_LAYER;
        }
        throw ElytronEEMessages.eeLog.unrecognisedContext(context.getClass().getName());
    }

    private static String toApplicationContext(Object context) {
        if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            String path = servletContext.getContextPath();
            return servletContext.getVirtualServerName() + " " + path;
        }
        throw ElytronEEMessages.eeLog.unrecognisedContext(context.getClass().getName());
    }

    private static void saveRegistration(String registration, Object context) {
        if (!(context instanceof ServletContext)) {
            throw ElytronEEMessages.eeLog.unrecognisedContext(context.getClass().getName());
        }
        ((ServletContext)context).setAttribute(REGISTRATION_KEY, (Object)registration);
    }

    private static String getRegistration(Object context) {
        if (context instanceof ServletContext) {
            String registration = (String)((ServletContext)context).getAttribute(REGISTRATION_KEY);
            if (registration == null) {
                throw ElytronEEMessages.eeLog.noSavedRegistration(ElytronAuthConfigFactory.toApplicationContext(context));
            }
            return registration;
        }
        throw ElytronEEMessages.eeLog.unrecognisedContext(context.getClass().getName());
    }

    static final class LayerContextKey {
        private final String messageLayer;
        private final String appContext;
        private final int hash;

        LayerContextKey(String messageLayer, String appContext) {
            this.messageLayer = messageLayer;
            this.appContext = appContext;
            this.hash = (messageLayer != null ? messageLayer.hashCode() : 7) * (appContext != null ? appContext.hashCode() : 13);
        }

        public boolean equals(Object other) {
            return other instanceof LayerContextKey ? this.equals((LayerContextKey)other) : false;
        }

        boolean equals(LayerContextKey other) {
            return (this.messageLayer != null ? this.messageLayer.equals(other.messageLayer) : other.messageLayer == null) && (this.appContext != null ? this.appContext.equals(other.appContext) : other.appContext == null);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class Registration {
        final String registrationId = UUID.randomUUID().toString();
        private boolean nullProvider;
        private AuthConfigProvider authConfigProvider;
        private List<RegistrationListener> registrationListeners = new ArrayList<RegistrationListener>();
        private final String appContext;
        private final String messageLayer;
        private String description;
        private boolean persistent;

        Registration(String messageLayer, String appContext) {
            this.messageLayer = messageLayer;
            this.appContext = appContext;
        }

        String getRegistrationId() {
            return this.registrationId;
        }

        void setDescription(String description) {
            this.description = description;
        }

        void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        void setAuthConfigProvider(AuthConfigProvider authConfigProvider, boolean nullProvider) {
            this.authConfigProvider = authConfigProvider;
            this.nullProvider = authConfigProvider == null ? nullProvider : false;
        }

        AuthConfigProvider getAuthConfigProvider() {
            return this.authConfigProvider;
        }

        boolean isNullProvider() {
            return this.nullProvider;
        }

        void addListener(RegistrationListener registrationListener) {
            this.registrationListeners.add(registrationListener);
        }

        boolean removeListener(RegistrationListener registrationListener) {
            return this.registrationListeners.remove(registrationListener);
        }

        List<RegistrationListener> clearListeners() {
            List<RegistrationListener> currentListeners = this.registrationListeners;
            this.registrationListeners = new ArrayList<RegistrationListener>();
            return currentListeners;
        }

        boolean activeRegistration() {
            return this.authConfigProvider != null || this.nullProvider;
        }

        AuthConfigFactory.RegistrationContext toRegistrationContext() {
            return this.activeRegistration() ? new ElytronRegistrationContext(this.messageLayer, this.appContext, this.description, this.persistent) : null;
        }
    }

    static class ElytronRegistrationContext
    implements AuthConfigFactory.RegistrationContext {
        private final String appContext;
        private final String messageLayer;
        private final String description;
        private final boolean persistent;

        ElytronRegistrationContext(String messageLayer, String appContext, String description, boolean persistent) {
            this.messageLayer = messageLayer;
            this.appContext = appContext;
            this.description = description;
            this.persistent = persistent;
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

