/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import java.util.concurrent.atomic.AtomicLongArray;

class CircularCountHolder {
    private final AtomicLongArray counts;
    private final int length;
    private int startIndex;
    private int endIndex;
    private int baseIndex;

    CircularCountHolder(int size) {
        this.length = size;
        this.counts = new AtomicLongArray(size);
        this.baseIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    long getValueAtIndex(int index) {
        return this.counts.get(this.getRelativeIndex(index));
    }

    boolean isEmpty() {
        return this.baseIndex == Integer.MIN_VALUE;
    }

    boolean increment(int index, long incrementBy) {
        if (this.baseIndex == Integer.MIN_VALUE) {
            this.baseIndex = index;
            this.startIndex = index;
            this.endIndex = index;
            this.counts.addAndGet(0, incrementBy);
            return true;
        }
        if (index > this.endIndex) {
            if ((long)index - (long)this.startIndex + 1L > (long)this.length) {
                return false;
            }
            this.endIndex = index;
        } else if (index < this.startIndex) {
            if ((long)this.endIndex - (long)index + 1L > (long)this.length) {
                return false;
            }
            this.startIndex = index;
        }
        this.counts.addAndGet(this.getRelativeIndex(index), incrementBy);
        return true;
    }

    private int getRelativeIndex(int index) {
        int result = index - this.baseIndex;
        if (result >= this.length) {
            result -= this.length;
        } else if (result < 0) {
            result += this.length;
        }
        return result;
    }

    void reset() {
        for (int i = 0; i < this.counts.length(); ++i) {
            this.counts.set(i, 0L);
        }
        this.baseIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
    }
}

