/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInterceptorRejectedPacketException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQRoutingException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;
import org.w3c.dom.Node;

public class ActiveMQClientMessageBundle_impl
implements ActiveMQClientMessageBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQClientMessageBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQInternalErrorException clientSessionClosed() {
        String returnString = "AMQ219000: ClientSession closed while creating session";
        ActiveMQInternalErrorException objReturn_clientSessionClosed = new ActiveMQInternalErrorException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_clientSessionClosed);
        return objReturn_clientSessionClosed;
    }

    @Override
    public ActiveMQInternalErrorException failedToCreateSession(Throwable t) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219001: Failed to create session", (Object[])new Object[]{t}).getMessage();
        ActiveMQInternalErrorException objReturn_failedToCreateSession = new ActiveMQInternalErrorException(returnString);
        objReturn_failedToCreateSession.initCause(t);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToCreateSession);
        return objReturn_failedToCreateSession;
    }

    @Override
    public ActiveMQInternalErrorException queueMisConfigured() {
        String returnString = "AMQ219003: Queue can not be both durable and temporary";
        ActiveMQInternalErrorException objReturn_queueMisConfigured = new ActiveMQInternalErrorException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_queueMisConfigured);
        return objReturn_queueMisConfigured;
    }

    @Override
    public ActiveMQInternalErrorException failedToInitialiseSessionFactory(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219004: Failed to initialise session factory", (Object[])new Object[]{e}).getMessage();
        ActiveMQInternalErrorException objReturn_failedToInitialiseSessionFactory = new ActiveMQInternalErrorException(returnString);
        objReturn_failedToInitialiseSessionFactory.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToInitialiseSessionFactory);
        return objReturn_failedToInitialiseSessionFactory;
    }

    @Override
    public ActiveMQInternalErrorException nettyError() {
        String returnString = "AMQ219005: Exception in Netty transport";
        ActiveMQInternalErrorException objReturn_nettyError = new ActiveMQInternalErrorException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_nettyError);
        return objReturn_nettyError;
    }

    @Override
    public ActiveMQNotConnectedException channelDisconnected() {
        String returnString = "AMQ219006: Channel disconnected";
        ActiveMQNotConnectedException objReturn_channelDisconnected = new ActiveMQNotConnectedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_channelDisconnected);
        return objReturn_channelDisconnected;
    }

    @Override
    public ActiveMQNotConnectedException cannotConnectToServers() {
        String returnString = "AMQ219007: Cannot connect to server(s). Tried with all available servers.";
        ActiveMQNotConnectedException objReturn_cannotConnectToServers = new ActiveMQNotConnectedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotConnectToServers);
        return objReturn_cannotConnectToServers;
    }

    @Override
    public ActiveMQNotConnectedException cannotConnectToStaticConnectors(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219008: Failed to connect to any static connectors", (Object[])new Object[]{e}).getMessage();
        ActiveMQNotConnectedException objReturn_cannotConnectToStaticConnectors = new ActiveMQNotConnectedException(returnString);
        objReturn_cannotConnectToStaticConnectors.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotConnectToStaticConnectors);
        return objReturn_cannotConnectToStaticConnectors;
    }

    @Override
    public ActiveMQNotConnectedException cannotConnectToStaticConnectors2() {
        String returnString = "AMQ219009: Failed to connect to any static connectors";
        ActiveMQNotConnectedException objReturn_cannotConnectToStaticConnectors2 = new ActiveMQNotConnectedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotConnectToStaticConnectors2);
        return objReturn_cannotConnectToStaticConnectors2;
    }

    @Override
    public ActiveMQNotConnectedException connectionDestroyed() {
        String returnString = "AMQ219010: Connection is destroyed";
        ActiveMQNotConnectedException objReturn_connectionDestroyed = new ActiveMQNotConnectedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionDestroyed);
        return objReturn_connectionDestroyed;
    }

    @Override
    public ActiveMQConnectionTimedOutException connectionTimedOut(Connection transportConnection) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219011: Did not receive data from server for {}", (Object[])new Object[]{transportConnection}).getMessage();
        ActiveMQConnectionTimedOutException objReturn_connectionTimedOut = new ActiveMQConnectionTimedOutException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionTimedOut);
        return objReturn_connectionTimedOut;
    }

    @Override
    public ActiveMQConnectionTimedOutException connectionTimedOutInInitialBroadcast() {
        String returnString = "AMQ219012: Timed out waiting to receive initial broadcast from cluster";
        ActiveMQConnectionTimedOutException objReturn_connectionTimedOutInInitialBroadcast = new ActiveMQConnectionTimedOutException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionTimedOutInInitialBroadcast);
        return objReturn_connectionTimedOutInInitialBroadcast;
    }

    @Override
    public ActiveMQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup discoveryGroup) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219013: Timed out waiting to receive cluster topology. Group:{}", (Object[])new Object[]{discoveryGroup}).getMessage();
        ActiveMQConnectionTimedOutException objReturn_connectionTimedOutOnReceiveTopology = new ActiveMQConnectionTimedOutException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionTimedOutOnReceiveTopology);
        return objReturn_connectionTimedOutOnReceiveTopology;
    }

    @Override
    public ActiveMQConnectionTimedOutException timedOutSendingPacket(long timeout, Byte type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219014: Timed out after waiting {} ms for response when sending packet {}", (Object[])new Object[]{timeout, type}).getMessage();
        ActiveMQConnectionTimedOutException objReturn_timedOutSendingPacket = new ActiveMQConnectionTimedOutException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_timedOutSendingPacket);
        return objReturn_timedOutSendingPacket;
    }

    @Override
    public ActiveMQDisconnectedException disconnected() {
        String returnString = "AMQ219015: The connection was disconnected because of server shutdown";
        ActiveMQDisconnectedException objReturn_disconnected = new ActiveMQDisconnectedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_disconnected);
        return objReturn_disconnected;
    }

    @Override
    public ActiveMQUnBlockedException unblockingACall(Throwable t) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219016: Connection failure detected. Unblocking a blocking call that will never get a response", (Object[])new Object[]{t}).getMessage();
        ActiveMQUnBlockedException objReturn_unblockingACall = new ActiveMQUnBlockedException(returnString);
        objReturn_unblockingACall.initCause(t);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_unblockingACall);
        return objReturn_unblockingACall;
    }

    @Override
    public ActiveMQObjectClosedException consumerClosed() {
        String returnString = "AMQ219017: Consumer is closed";
        ActiveMQObjectClosedException objReturn_consumerClosed = new ActiveMQObjectClosedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_consumerClosed);
        return objReturn_consumerClosed;
    }

    @Override
    public ActiveMQObjectClosedException producerClosed() {
        String returnString = "AMQ219018: Producer is closed";
        ActiveMQObjectClosedException objReturn_producerClosed = new ActiveMQObjectClosedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_producerClosed);
        return objReturn_producerClosed;
    }

    @Override
    public ActiveMQObjectClosedException sessionClosed() {
        String returnString = "AMQ219019: Session is closed";
        ActiveMQObjectClosedException objReturn_sessionClosed = new ActiveMQObjectClosedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_sessionClosed);
        return objReturn_sessionClosed;
    }

    @Override
    public ActiveMQIllegalStateException messageHandlerSet() {
        String returnString = "AMQ219020: Cannot call receive(...) - a MessageHandler is set";
        ActiveMQIllegalStateException objReturn_messageHandlerSet = new ActiveMQIllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_messageHandlerSet);
        return objReturn_messageHandlerSet;
    }

    @Override
    public ActiveMQIllegalStateException inReceive() {
        String returnString = "AMQ219021: Cannot set MessageHandler - consumer is in receive(...)";
        ActiveMQIllegalStateException objReturn_inReceive = new ActiveMQIllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_inReceive);
        return objReturn_inReceive;
    }

    @Override
    public ActiveMQIllegalStateException headerSizeTooBig(Integer headerSize) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219022: Header size ({}) is too big, use the messageBody for large data, or increase minLargeMessageSize", (Object[])new Object[]{headerSize}).getMessage();
        ActiveMQIllegalStateException objReturn_headerSizeTooBig = new ActiveMQIllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_headerSizeTooBig);
        return objReturn_headerSizeTooBig;
    }

    @Override
    public ActiveMQIllegalStateException largeMessageLostSession() {
        String returnString = "AMQ219023: The large message lost connection with its session, either because of a rollback or a closed session";
        ActiveMQIllegalStateException objReturn_largeMessageLostSession = new ActiveMQIllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_largeMessageLostSession);
        return objReturn_largeMessageLostSession;
    }

    @Override
    public ActiveMQIllegalStateException noTCForSessionFactory() {
        String returnString = "AMQ219024: Could not select a TransportConfiguration to create SessionFactory";
        ActiveMQIllegalStateException objReturn_noTCForSessionFactory = new ActiveMQIllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noTCForSessionFactory);
        return objReturn_noTCForSessionFactory;
    }

    @Override
    public ActiveMQLargeMessageException errorSavingBody(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219025: Error saving the message body", (Object[])new Object[]{e}).getMessage();
        ActiveMQLargeMessageException objReturn_errorSavingBody = new ActiveMQLargeMessageException(returnString);
        objReturn_errorSavingBody.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorSavingBody);
        return objReturn_errorSavingBody;
    }

    @Override
    public ActiveMQLargeMessageException errorReadingBody(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219026: Error reading the LargeMessageBody", (Object[])new Object[]{e}).getMessage();
        ActiveMQLargeMessageException objReturn_errorReadingBody = new ActiveMQLargeMessageException(returnString);
        objReturn_errorReadingBody.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorReadingBody);
        return objReturn_errorReadingBody;
    }

    @Override
    public ActiveMQLargeMessageException errorClosingLargeMessage(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219027: Error closing stream from LargeMessageBody", (Object[])new Object[]{e}).getMessage();
        ActiveMQLargeMessageException objReturn_errorClosingLargeMessage = new ActiveMQLargeMessageException(returnString);
        objReturn_errorClosingLargeMessage.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorClosingLargeMessage);
        return objReturn_errorClosingLargeMessage;
    }

    @Override
    public ActiveMQLargeMessageException timeoutOnLargeMessage() {
        String returnString = "AMQ219028: Timeout waiting for LargeMessage Body";
        ActiveMQLargeMessageException objReturn_timeoutOnLargeMessage = new ActiveMQLargeMessageException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_timeoutOnLargeMessage);
        return objReturn_timeoutOnLargeMessage;
    }

    @Override
    public ActiveMQLargeMessageException errorWritingLargeMessage(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219029: Error writing body of message", (Object[])new Object[]{e}).getMessage();
        ActiveMQLargeMessageException objReturn_errorWritingLargeMessage = new ActiveMQLargeMessageException(returnString);
        objReturn_errorWritingLargeMessage.initCause((Throwable)e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorWritingLargeMessage);
        return objReturn_errorWritingLargeMessage;
    }

    @Override
    public ActiveMQTransactionRolledBackException txRolledBack() {
        String returnString = "AMQ219030: The transaction was rolled back on failover to a backup server";
        ActiveMQTransactionRolledBackException objReturn_txRolledBack = new ActiveMQTransactionRolledBackException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_txRolledBack);
        return objReturn_txRolledBack;
    }

    @Override
    public ActiveMQTransactionOutcomeUnknownException txOutcomeUnknown() {
        String returnString = "AMQ219031: The transaction was rolled back on failover however commit may have been successful";
        ActiveMQTransactionOutcomeUnknownException objReturn_txOutcomeUnknown = new ActiveMQTransactionOutcomeUnknownException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_txOutcomeUnknown);
        return objReturn_txOutcomeUnknown;
    }

    @Override
    public IllegalArgumentException invalidType(Object type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219032: Invalid type: {}", (Object[])new Object[]{type}).getMessage();
        IllegalArgumentException objReturn_invalidType = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidType);
        return objReturn_invalidType;
    }

    @Override
    public IllegalArgumentException invalidEncodeType(Object type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219033: Invalid type: {}", (Object[])new Object[]{type}).getMessage();
        IllegalArgumentException objReturn_invalidEncodeType = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidEncodeType);
        return objReturn_invalidEncodeType;
    }

    @Override
    public IllegalArgumentException invalidManagementParam(Object type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219034: Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {}", (Object[])new Object[]{type}).getMessage();
        IllegalArgumentException objReturn_invalidManagementParam = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidManagementParam);
        return objReturn_invalidManagementParam;
    }

    @Override
    public IllegalArgumentException invalidWindowSize(Integer size) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219035: Invalid window size {}", (Object[])new Object[]{size}).getMessage();
        IllegalArgumentException objReturn_invalidWindowSize = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidWindowSize);
        return objReturn_invalidWindowSize;
    }

    @Override
    public IllegalArgumentException invalidCommandID(Integer lastReceivedCommandID) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219037: Invalid last Received Command ID: {}", (Object[])new Object[]{lastReceivedCommandID}).getMessage();
        IllegalArgumentException objReturn_invalidCommandID = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidCommandID);
        return objReturn_invalidCommandID;
    }

    @Override
    public IllegalArgumentException noChannelToClose(Long id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219038: Cannot find channel with id {} to close", (Object[])new Object[]{id}).getMessage();
        IllegalArgumentException objReturn_noChannelToClose = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_noChannelToClose);
        return objReturn_noChannelToClose;
    }

    @Override
    public IllegalArgumentException closeListenerCannotBeNull() {
        String returnString = "AMQ219039: Close Listener cannot be null";
        IllegalArgumentException objReturn_closeListenerCannotBeNull = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_closeListenerCannotBeNull);
        return objReturn_closeListenerCannotBeNull;
    }

    @Override
    public IllegalArgumentException failListenerCannotBeNull() {
        String returnString = "AMQ219040: Fail Listener cannot be null";
        IllegalArgumentException objReturn_failListenerCannotBeNull = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_failListenerCannotBeNull);
        return objReturn_failListenerCannotBeNull;
    }

    @Override
    public IllegalArgumentException connectionExists(Object id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219041: Connection already exists with id {}", (Object[])new Object[]{id}).getMessage();
        IllegalArgumentException objReturn_connectionExists = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_connectionExists);
        return objReturn_connectionExists;
    }

    @Override
    public IllegalArgumentException nullListener() {
        String returnString = "AMQ219042: Invalid argument null listener";
        IllegalArgumentException objReturn_nullListener = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullListener);
        return objReturn_nullListener;
    }

    @Override
    public IllegalArgumentException nullHandler() {
        String returnString = "AMQ219043: Invalid argument null handler";
        IllegalArgumentException objReturn_nullHandler = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullHandler);
        return objReturn_nullHandler;
    }

    @Override
    public IllegalArgumentException firstNodeNull() {
        String returnString = "AMQ219045: the first node to be compared is null";
        IllegalArgumentException objReturn_firstNodeNull = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_firstNodeNull);
        return objReturn_firstNodeNull;
    }

    @Override
    public IllegalArgumentException secondNodeNull() {
        String returnString = "AMQ219046: the second node to be compared is null";
        IllegalArgumentException objReturn_secondNodeNull = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_secondNodeNull);
        return objReturn_secondNodeNull;
    }

    @Override
    public IllegalArgumentException nodeHaveDifferentNames() {
        String returnString = "AMQ219047: nodes have different node names";
        IllegalArgumentException objReturn_nodeHaveDifferentNames = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_nodeHaveDifferentNames);
        return objReturn_nodeHaveDifferentNames;
    }

    @Override
    public IllegalArgumentException nodeHaveDifferentAttNumber() {
        String returnString = "AMQ219048: nodes have a different number of attributes";
        IllegalArgumentException objReturn_nodeHaveDifferentAttNumber = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_nodeHaveDifferentAttNumber);
        return objReturn_nodeHaveDifferentAttNumber;
    }

    @Override
    public IllegalArgumentException attsDontMatch(String name, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219049: attribute {}={} does not match", (Object[])new Object[]{name, value}).getMessage();
        IllegalArgumentException objReturn_attsDontMatch = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_attsDontMatch);
        return objReturn_attsDontMatch;
    }

    @Override
    public IllegalArgumentException oneNodeHasChildren() {
        String returnString = "AMQ219050: one node has children and the other does not";
        IllegalArgumentException objReturn_oneNodeHasChildren = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_oneNodeHasChildren);
        return objReturn_oneNodeHasChildren;
    }

    @Override
    public IllegalArgumentException nodeHasDifferentChildNumber() {
        String returnString = "AMQ219051: nodes have a different number of children";
        IllegalArgumentException objReturn_nodeHasDifferentChildNumber = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_nodeHasDifferentChildNumber);
        return objReturn_nodeHasDifferentChildNumber;
    }

    @Override
    public IllegalArgumentException mustBeBoolean(Node elem, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219052: Element {} requires a valid Boolean value, but '{}' cannot be parsed as a Boolean", (Object[])new Object[]{elem, value}).getMessage();
        IllegalArgumentException objReturn_mustBeBoolean = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_mustBeBoolean);
        return objReturn_mustBeBoolean;
    }

    @Override
    public IllegalArgumentException mustBeDouble(Node elem, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219053: Element {} requires a valid Double value, but '{}' cannot be parsed as a Double", (Object[])new Object[]{elem, value}).getMessage();
        IllegalArgumentException objReturn_mustBeDouble = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_mustBeDouble);
        return objReturn_mustBeDouble;
    }

    @Override
    public IllegalArgumentException mustBeInteger(Node elem, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219054: Element {} requires a valid Integer value, but '{}' cannot be parsed as an Integer", (Object[])new Object[]{elem, value}).getMessage();
        IllegalArgumentException objReturn_mustBeInteger = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_mustBeInteger);
        return objReturn_mustBeInteger;
    }

    @Override
    public IllegalArgumentException mustBeLong(Node element, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219055: Element {} requires a valid Long value, but '{}' cannot be parsed as a Long", (Object[])new Object[]{element, value}).getMessage();
        IllegalArgumentException objReturn_mustBeLong = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_mustBeLong);
        return objReturn_mustBeLong;
    }

    @Override
    public IllegalArgumentException errordecodingPassword(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219057: Error decoding password", (Object[])new Object[]{e}).getMessage();
        IllegalArgumentException objReturn_errordecodingPassword = new IllegalArgumentException(returnString);
        objReturn_errordecodingPassword.initCause(e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_errordecodingPassword);
        return objReturn_errordecodingPassword;
    }

    @Override
    public ActiveMQAddressFullException addressIsFull(String addressName, int size) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219058: Address \"{}\" is full. Message encode size = {}B", (Object[])new Object[]{addressName, size}).getMessage();
        ActiveMQAddressFullException objReturn_addressIsFull = new ActiveMQAddressFullException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_addressIsFull);
        return objReturn_addressIsFull;
    }

    @Override
    public ActiveMQInterceptorRejectedPacketException interceptorRejectedPacket(String interceptionResult) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219059: Interceptor {} rejected packet in a blocking call. This call will never complete.", (Object[])new Object[]{interceptionResult}).getMessage();
        ActiveMQInterceptorRejectedPacketException objReturn_interceptorRejectedPacket = new ActiveMQInterceptorRejectedPacketException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_interceptorRejectedPacket);
        return objReturn_interceptorRejectedPacket;
    }

    @Override
    public ActiveMQLargeMessageInterruptedException largeMessageInterrupted() {
        String returnString = "AMQ219060: Large Message Transmission interrupted on consumer shutdown.";
        ActiveMQLargeMessageInterruptedException objReturn_largeMessageInterrupted = new ActiveMQLargeMessageInterruptedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_largeMessageInterrupted);
        return objReturn_largeMessageInterrupted;
    }

    @Override
    public IllegalStateException cannotSendPacketDuringFailover() {
        String returnString = "AMQ219061: Cannot send a packet while channel is failing over.";
        IllegalStateException objReturn_cannotSendPacketDuringFailover = new IllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotSendPacketDuringFailover);
        return objReturn_cannotSendPacketDuringFailover;
    }

    @Override
    public ActiveMQInterruptedException packetTransmissionInterrupted() {
        String returnString = "AMQ219062: Multi-packet transmission (e.g. Large Messages) interrupted because of a reconnection.";
        ActiveMQInterruptedException objReturn_packetTransmissionInterrupted = new ActiveMQInterruptedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_packetTransmissionInterrupted);
        return objReturn_packetTransmissionInterrupted;
    }

    @Override
    public IllegalStateException cannotSendPacketWhilstResponseCacheFull() {
        String returnString = "AMQ219063: Cannot send a packet while response cache is full.";
        IllegalStateException objReturn_cannotSendPacketWhilstResponseCacheFull = new IllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotSendPacketWhilstResponseCacheFull);
        return objReturn_cannotSendPacketWhilstResponseCacheFull;
    }

    @Override
    public IllegalStateException invalidPacket(byte type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219064: Invalide packet: {}", (Object[])new Object[]{type}).getMessage();
        IllegalStateException objReturn_invalidPacket = new IllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidPacket);
        return objReturn_invalidPacket;
    }

    @Override
    public RuntimeException failedToHandlePacket(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219065: Failed to handle packet.", (Object[])new Object[]{e}).getMessage();
        RuntimeException objReturn_failedToHandlePacket = new RuntimeException(returnString);
        objReturn_failedToHandlePacket.initCause(e);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_failedToHandlePacket);
        return objReturn_failedToHandlePacket;
    }

    @Override
    public ActiveMQRoutingException redirected() {
        String returnString = "AMQ219066: The connection was redirected";
        ActiveMQRoutingException objReturn_redirected = new ActiveMQRoutingException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_redirected);
        return objReturn_redirected;
    }

    @Override
    public IllegalArgumentException keystoreAliasNotFound(String keystoreAlias, String keystorePath) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219067: Keystore alias {} not found in {}", (Object[])new Object[]{keystoreAlias, keystorePath}).getMessage();
        IllegalArgumentException objReturn_keystoreAliasNotFound = new IllegalArgumentException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_keystoreAliasNotFound);
        return objReturn_keystoreAliasNotFound;
    }

    @Override
    public ActiveMQObjectClosedException connectionClosedOnReceiveTopology(DiscoveryGroup discoveryGroup) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ219068: Connection closed while receiving cluster topology. Group:{}", (Object[])new Object[]{discoveryGroup}).getMessage();
        ActiveMQObjectClosedException objReturn_connectionClosedOnReceiveTopology = new ActiveMQObjectClosedException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionClosedOnReceiveTopology);
        return objReturn_connectionClosedOnReceiveTopology;
    }

    @Override
    public IllegalStateException unableToCreateSession() {
        String returnString = "AMQ219069: Unable to create Session. Either the ClientSessionFactory is closed or the ClientProtocolManager is dead.";
        IllegalStateException objReturn_unableToCreateSession = new IllegalStateException(returnString);
        ActiveMQClientMessageBundle_impl._copyStackTraceMinusOne(objReturn_unableToCreateSession);
        return objReturn_unableToCreateSession;
    }
}

