/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import java.util.UUID;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @Test
    public void simpleTest() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeString(data);
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        Assertions.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
    }
}

